/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.ethelred.kiwiproc.processor.Signature;
import org.ethelred.kiwiproc.processor.types.KiwiType;

public class SignatureBuilder {
    private final boolean[] _onceOnlyCheck = new boolean[3];
    private KiwiType returnType;
    private String methodName;
    private List<String> paramNames;

    private SignatureBuilder() {
    }

    private SignatureBuilder(KiwiType returnType, String methodName, List<String> paramNames) {
        this.returnType = returnType;
        this.methodName = methodName;
        this.paramNames = paramNames;
    }

    public static ReturnTypeStage builder() {
        SignatureBuilder r = new SignatureBuilder();
        return returnType -> {
            r.returnType(returnType);
            return methodName -> {
                r.methodName(methodName);
                return paramNames -> {
                    r.paramNames(paramNames);
                    return () -> r;
                };
            };
        };
    }

    public static Signature Signature(KiwiType returnType, String methodName, List<String> paramNames) {
        paramNames = SignatureBuilder.__list(paramNames);
        return new Signature(returnType, methodName, paramNames);
    }

    public static SignatureBuilder builder(Signature from) {
        return new SignatureBuilder(from.returnType(), from.methodName(), from.paramNames());
    }

    public static With from(Signature from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(Signature record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, KiwiType>("returnType", record.returnType()), new AbstractMap.SimpleImmutableEntry<String, String>("methodName", record.methodName()), new AbstractMap.SimpleImmutableEntry<String, List<String>>("paramNames", record.paramNames()));
    }

    public Signature build() {
        this.paramNames = SignatureBuilder.__list(this.paramNames);
        return new Signature(this.returnType, this.methodName, this.paramNames);
    }

    public String toString() {
        return "SignatureBuilder[returnType=" + this.returnType + ", methodName=" + this.methodName + ", paramNames=" + this.paramNames + "]";
    }

    public int hashCode() {
        return Objects.hash(this.returnType, this.methodName, this.paramNames);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SignatureBuilder)) return false;
        SignatureBuilder r = (SignatureBuilder)o;
        if (!Objects.equals(this.returnType, r.returnType)) return false;
        if (!Objects.equals(this.methodName, r.methodName)) return false;
        if (!Objects.equals(this.paramNames, r.paramNames)) return false;
        return true;
    }

    public SignatureBuilder returnType(KiwiType returnType) {
        if (this._onceOnlyCheck[0]) {
            throw new IllegalStateException("A value has already been set for: returnType");
        }
        this._onceOnlyCheck[0] = true;
        this.returnType = returnType;
        return this;
    }

    public KiwiType returnType() {
        return this.returnType;
    }

    public SignatureBuilder methodName(String methodName) {
        if (this._onceOnlyCheck[1]) {
            throw new IllegalStateException("A value has already been set for: methodName");
        }
        this._onceOnlyCheck[1] = true;
        this.methodName = methodName;
        return this;
    }

    public String methodName() {
        return this.methodName;
    }

    public SignatureBuilder paramNames(Collection<? extends String> paramNames) {
        if (this._onceOnlyCheck[2]) {
            throw new IllegalStateException("A value has already been set for: paramNames");
        }
        this._onceOnlyCheck[2] = true;
        this.paramNames = SignatureBuilder.__list(paramNames);
        return this;
    }

    public List<String> paramNames() {
        return SignatureBuilder.__list(this.paramNames);
    }

    public SignatureBuilder addParamNames(String i) {
        this.paramNames = SignatureBuilder.__ensureListMutable(this.paramNames);
        this.paramNames.add(i);
        return this;
    }

    public SignatureBuilder addParamNames(Stream<? extends String> i) {
        this.paramNames = SignatureBuilder.__ensureListMutable(this.paramNames);
        i.forEach(this.paramNames::add);
        return this;
    }

    public SignatureBuilder addParamNames(Iterable<? extends String> i) {
        this.paramNames = SignatureBuilder.__ensureListMutable(this.paramNames);
        i.forEach(this.paramNames::add);
        return this;
    }

    private static <T> List<T> __list(Collection<? extends T> o) {
        return o != null ? List.copyOf(o) : List.of();
    }

    private static <T> List<T> __ensureListMutable(List<T> o) {
        if (o == null) {
            return new _MutableList();
        }
        if (o instanceof _MutableList) {
            return o;
        }
        return new _MutableList<T>(o);
    }

    public static interface ReturnTypeStage {
        public MethodNameStage returnType(KiwiType var1);
    }

    private static final class _FromWith
    implements With {
        private final Signature from;

        private _FromWith(Signature from) {
            this.from = from;
        }

        @Override
        public KiwiType returnType() {
            return this.from.returnType();
        }

        @Override
        public String methodName() {
            return this.from.methodName();
        }

        @Override
        public List<String> paramNames() {
            return this.from.paramNames();
        }
    }

    private static class _MutableList<T>
    extends ArrayList<T> {
        public static final long serialVersionUID = 1L;

        _MutableList() {
        }

        _MutableList(List<T> o) {
            super(o);
        }
    }

    public static interface MethodNameStage {
        public ParamNamesStage methodName(String var1);
    }

    public static interface ParamNamesStage {
        public SignatureBuilderStage paramNames(List<String> var1);
    }

    public static interface SignatureBuilderStage {
        default public Signature build() {
            return this.builder().build();
        }

        public SignatureBuilder builder();
    }

    public static interface With {
        public KiwiType returnType();

        public String methodName();

        public List<String> paramNames();

        default public SignatureBuilder with() {
            return new SignatureBuilder(this.returnType(), this.methodName(), this.paramNames());
        }

        default public Signature with(java.util.function.Consumer<SignatureBuilder> consumer) {
            SignatureBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public Signature withReturnType(KiwiType returnType) {
            return new Signature(returnType, this.methodName(), this.paramNames());
        }

        default public Signature withMethodName(String methodName) {
            return new Signature(this.returnType(), methodName, this.paramNames());
        }

        default public Signature withParamNames(List<String> paramNames) {
            return new Signature(this.returnType(), this.methodName(), SignatureBuilder.__list(paramNames));
        }

        default public <R> R map(Function<R> proc) {
            return proc.apply(this.returnType(), this.methodName(), this.paramNames());
        }

        default public void accept(Consumer proc) {
            proc.apply(this.returnType(), this.methodName(), this.paramNames());
        }

        @FunctionalInterface
        public static interface Function<R> {
            public R apply(KiwiType var1, String var2, List<String> var3);
        }

        @FunctionalInterface
        public static interface Consumer {
            public void apply(KiwiType var1, String var2, List<String> var3);
        }
    }
}

