/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ethelred.kiwiproc.meta.ColumnMetaData;
import org.ethelred.kiwiproc.processor.CoreTypes;
import org.ethelred.kiwiproc.processor.SqlTypeMappingBuilder;
import org.ethelred.kiwiproc.processor.types.BasicType;
import org.ethelred.kiwiproc.processor.types.KiwiType;
import org.ethelred.kiwiproc.processor.types.PrimitiveKiwiType;
import org.ethelred.kiwiproc.processor.types.SqlArrayType;
import org.jspecify.annotations.Nullable;

public record SqlTypeMapping(JDBCType jdbcType, Class<?> baseType, String accessorSuffix, boolean specialCase, boolean isNullable, @Nullable SqlTypeMapping componentType, @Nullable String componentDbType) implements SqlTypeMappingBuilder.With
{
    private static final List<SqlTypeMapping> types = List.of(new SqlTypeMapping(JDBCType.BIT, Boolean.TYPE, "Boolean"), new SqlTypeMapping(JDBCType.BOOLEAN, Boolean.TYPE, "Boolean"), new SqlTypeMapping(JDBCType.BIGINT, Long.TYPE, "Long"), new SqlTypeMapping(JDBCType.TINYINT, Byte.TYPE, "Byte"), new SqlTypeMapping(JDBCType.SMALLINT, Short.TYPE, "Short"), new SqlTypeMapping(JDBCType.INTEGER, Integer.TYPE, "Int"), new SqlTypeMapping(JDBCType.FLOAT, Double.TYPE, "Double"), new SqlTypeMapping(JDBCType.REAL, Float.TYPE, "Float"), new SqlTypeMapping(JDBCType.DOUBLE, Double.TYPE, "Double"), new SqlTypeMapping(JDBCType.NUMERIC, BigDecimal.class, "BigDecimal"), new SqlTypeMapping(JDBCType.DECIMAL, BigDecimal.class, "BigDecimal"), new SqlTypeMapping(JDBCType.CHAR, String.class, "String"), new SqlTypeMapping(JDBCType.VARCHAR, String.class, "String"), new SqlTypeMapping(JDBCType.LONGVARCHAR, String.class, "String"), new SqlTypeMapping(JDBCType.NCHAR, String.class, "String"), new SqlTypeMapping(JDBCType.NVARCHAR, String.class, "String"), new SqlTypeMapping(JDBCType.LONGNVARCHAR, String.class, "String"), new SqlTypeMapping(JDBCType.ARRAY, Array.class, "Array", true, false, null, null), new SqlTypeMapping(JDBCType.DATE, LocalDate.class, "Object"), new SqlTypeMapping(JDBCType.TIME, LocalTime.class, "Object"), new SqlTypeMapping(JDBCType.TIME_WITH_TIMEZONE, OffsetTime.class, "Object"), new SqlTypeMapping(JDBCType.TIMESTAMP, LocalDateTime.class, "Object"), new SqlTypeMapping(JDBCType.TIMESTAMP_WITH_TIMEZONE, OffsetDateTime.class, "Object"), new SqlTypeMapping(JDBCType.NULL, Void.TYPE, "", true, true, null, null));
    private static final Map<JDBCType, SqlTypeMapping> JDBC_TYPE_SQL_TYPE_MAPPING_MAP = types.stream().collect(Collectors.toMap(SqlTypeMapping::jdbcType, t -> t));

    public SqlTypeMapping(JDBCType jdbcType, Class<?> baseType, String accessorSuffix) {
        this(jdbcType, baseType, accessorSuffix, false, false, null, null);
    }

    public static SqlTypeMapping get(ColumnMetaData columnMetaData) {
        SqlTypeMapping r = JDBC_TYPE_SQL_TYPE_MAPPING_MAP.get(columnMetaData.sqlType());
        if (r == null) {
            throw new IllegalArgumentException("Unsupported JDBCType type " + columnMetaData.sqlType());
        }
        if (r.jdbcType == JDBCType.ARRAY) {
            if (columnMetaData.componentType() == null) {
                throw new IllegalArgumentException("No component type provided for SQL Array");
            }
            SqlTypeMapping component = JDBC_TYPE_SQL_TYPE_MAPPING_MAP.get(columnMetaData.componentType().jdbcType());
            if (component == null) {
                throw new IllegalArgumentException("No component type found for SQL Array");
            }
            r = r.withComponentType(component).withComponentDbType(columnMetaData.componentType().dbType());
        }
        return r.withIsNullable(columnMetaData.nullable());
    }

    public KiwiType kiwiType() {
        if (this.jdbcType == JDBCType.ARRAY) {
            assert (this.componentType != null);
            return new SqlArrayType(this.componentType.kiwiType(), this.componentType, this.componentDbType);
        }
        if (CoreTypes.primitiveToBoxed.containsKey(this.baseType)) {
            return new PrimitiveKiwiType(this.baseType().getSimpleName(), this.isNullable);
        }
        return new BasicType(this.baseType.getPackageName(), this.baseType.getSimpleName(), this.isNullable);
    }
}

