/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import java.sql.JDBCType;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.ethelred.kiwiproc.processor.SqlTypeMapping;

public class SqlTypeMappingBuilder {
    private final boolean[] _onceOnlyCheck = new boolean[7];
    private JDBCType jdbcType;
    private Class<?> baseType;
    private String accessorSuffix;
    private boolean specialCase;
    private boolean isNullable;
    private SqlTypeMapping componentType;
    private String componentDbType;

    private SqlTypeMappingBuilder() {
    }

    private SqlTypeMappingBuilder(JDBCType jdbcType, Class<?> baseType, String accessorSuffix, boolean specialCase, boolean isNullable, SqlTypeMapping componentType, String componentDbType) {
        this.jdbcType = jdbcType;
        this.baseType = baseType;
        this.accessorSuffix = accessorSuffix;
        this.specialCase = specialCase;
        this.isNullable = isNullable;
        this.componentType = componentType;
        this.componentDbType = componentDbType;
    }

    public static JdbcTypeStage builder() {
        SqlTypeMappingBuilder r = new SqlTypeMappingBuilder();
        return jdbcType -> {
            r.jdbcType(jdbcType);
            return baseType -> {
                r.baseType(baseType);
                return accessorSuffix -> {
                    r.accessorSuffix(accessorSuffix);
                    return specialCase -> {
                        r.specialCase(specialCase);
                        return isNullable -> {
                            r.isNullable(isNullable);
                            return componentType -> {
                                r.componentType(componentType);
                                return componentDbType -> {
                                    r.componentDbType(componentDbType);
                                    return () -> r;
                                };
                            };
                        };
                    };
                };
            };
        };
    }

    public static SqlTypeMapping SqlTypeMapping(JDBCType jdbcType, Class<?> baseType, String accessorSuffix, boolean specialCase, boolean isNullable, SqlTypeMapping componentType, String componentDbType) {
        return new SqlTypeMapping(jdbcType, baseType, accessorSuffix, specialCase, isNullable, componentType, componentDbType);
    }

    public static SqlTypeMappingBuilder builder(SqlTypeMapping from) {
        return new SqlTypeMappingBuilder(from.jdbcType(), from.baseType(), from.accessorSuffix(), from.specialCase(), from.isNullable(), from.componentType(), from.componentDbType());
    }

    public static With from(SqlTypeMapping from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(SqlTypeMapping record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, JDBCType>("jdbcType", record.jdbcType()), new AbstractMap.SimpleImmutableEntry("baseType", record.baseType()), new AbstractMap.SimpleImmutableEntry<String, String>("accessorSuffix", record.accessorSuffix()), new AbstractMap.SimpleImmutableEntry<String, Boolean>("specialCase", record.specialCase()), new AbstractMap.SimpleImmutableEntry<String, Boolean>("isNullable", record.isNullable()), new AbstractMap.SimpleImmutableEntry<String, SqlTypeMapping>("componentType", record.componentType()), new AbstractMap.SimpleImmutableEntry<String, String>("componentDbType", record.componentDbType()));
    }

    public SqlTypeMapping build() {
        return new SqlTypeMapping(this.jdbcType, this.baseType, this.accessorSuffix, this.specialCase, this.isNullable, this.componentType, this.componentDbType);
    }

    public String toString() {
        return "SqlTypeMappingBuilder[jdbcType=" + this.jdbcType + ", baseType=" + this.baseType + ", accessorSuffix=" + this.accessorSuffix + ", specialCase=" + this.specialCase + ", isNullable=" + this.isNullable + ", componentType=" + this.componentType + ", componentDbType=" + this.componentDbType + "]";
    }

    public int hashCode() {
        return Objects.hash(this.jdbcType, this.baseType, this.accessorSuffix, this.specialCase, this.isNullable, this.componentType, this.componentDbType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SqlTypeMappingBuilder)) return false;
        SqlTypeMappingBuilder r = (SqlTypeMappingBuilder)o;
        if (!Objects.equals(this.jdbcType, r.jdbcType)) return false;
        if (!Objects.equals(this.baseType, r.baseType)) return false;
        if (!Objects.equals(this.accessorSuffix, r.accessorSuffix)) return false;
        if (this.specialCase != r.specialCase) return false;
        if (this.isNullable != r.isNullable) return false;
        if (!Objects.equals(this.componentType, r.componentType)) return false;
        if (!Objects.equals(this.componentDbType, r.componentDbType)) return false;
        return true;
    }

    public SqlTypeMappingBuilder jdbcType(JDBCType jdbcType) {
        if (this._onceOnlyCheck[0]) {
            throw new IllegalStateException("A value has already been set for: jdbcType");
        }
        this._onceOnlyCheck[0] = true;
        this.jdbcType = jdbcType;
        return this;
    }

    public JDBCType jdbcType() {
        return this.jdbcType;
    }

    public SqlTypeMappingBuilder baseType(Class<?> baseType) {
        if (this._onceOnlyCheck[1]) {
            throw new IllegalStateException("A value has already been set for: baseType");
        }
        this._onceOnlyCheck[1] = true;
        this.baseType = baseType;
        return this;
    }

    public Class<?> baseType() {
        return this.baseType;
    }

    public SqlTypeMappingBuilder accessorSuffix(String accessorSuffix) {
        if (this._onceOnlyCheck[2]) {
            throw new IllegalStateException("A value has already been set for: accessorSuffix");
        }
        this._onceOnlyCheck[2] = true;
        this.accessorSuffix = accessorSuffix;
        return this;
    }

    public String accessorSuffix() {
        return this.accessorSuffix;
    }

    public SqlTypeMappingBuilder specialCase(boolean specialCase) {
        if (this._onceOnlyCheck[3]) {
            throw new IllegalStateException("A value has already been set for: specialCase");
        }
        this._onceOnlyCheck[3] = true;
        this.specialCase = specialCase;
        return this;
    }

    public boolean specialCase() {
        return this.specialCase;
    }

    public SqlTypeMappingBuilder isNullable(boolean isNullable) {
        if (this._onceOnlyCheck[4]) {
            throw new IllegalStateException("A value has already been set for: isNullable");
        }
        this._onceOnlyCheck[4] = true;
        this.isNullable = isNullable;
        return this;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public SqlTypeMappingBuilder componentType(SqlTypeMapping componentType) {
        if (this._onceOnlyCheck[5]) {
            throw new IllegalStateException("A value has already been set for: componentType");
        }
        this._onceOnlyCheck[5] = true;
        this.componentType = componentType;
        return this;
    }

    public SqlTypeMapping componentType() {
        return this.componentType;
    }

    public SqlTypeMappingBuilder componentDbType(String componentDbType) {
        if (this._onceOnlyCheck[6]) {
            throw new IllegalStateException("A value has already been set for: componentDbType");
        }
        this._onceOnlyCheck[6] = true;
        this.componentDbType = componentDbType;
        return this;
    }

    public String componentDbType() {
        return this.componentDbType;
    }

    public static interface JdbcTypeStage {
        public BaseTypeStage jdbcType(JDBCType var1);
    }

    private static final class _FromWith
    implements With {
        private final SqlTypeMapping from;

        private _FromWith(SqlTypeMapping from) {
            this.from = from;
        }

        @Override
        public JDBCType jdbcType() {
            return this.from.jdbcType();
        }

        @Override
        public Class<?> baseType() {
            return this.from.baseType();
        }

        @Override
        public String accessorSuffix() {
            return this.from.accessorSuffix();
        }

        @Override
        public boolean specialCase() {
            return this.from.specialCase();
        }

        @Override
        public boolean isNullable() {
            return this.from.isNullable();
        }

        @Override
        public SqlTypeMapping componentType() {
            return this.from.componentType();
        }

        @Override
        public String componentDbType() {
            return this.from.componentDbType();
        }
    }

    public static interface BaseTypeStage {
        public AccessorSuffixStage baseType(Class<?> var1);
    }

    public static interface AccessorSuffixStage {
        public SpecialCaseStage accessorSuffix(String var1);
    }

    public static interface SpecialCaseStage {
        public IsNullableStage specialCase(boolean var1);
    }

    public static interface IsNullableStage {
        public ComponentTypeStage isNullable(boolean var1);
    }

    public static interface ComponentTypeStage {
        public ComponentDbTypeStage componentType(SqlTypeMapping var1);
    }

    public static interface ComponentDbTypeStage {
        public SqlTypeMappingBuilderStage componentDbType(String var1);
    }

    public static interface SqlTypeMappingBuilderStage {
        default public SqlTypeMapping build() {
            return this.builder().build();
        }

        public SqlTypeMappingBuilder builder();
    }

    public static interface With {
        public JDBCType jdbcType();

        public Class<?> baseType();

        public String accessorSuffix();

        public boolean specialCase();

        public boolean isNullable();

        public SqlTypeMapping componentType();

        public String componentDbType();

        default public SqlTypeMappingBuilder with() {
            return new SqlTypeMappingBuilder(this.jdbcType(), this.baseType(), this.accessorSuffix(), this.specialCase(), this.isNullable(), this.componentType(), this.componentDbType());
        }

        default public SqlTypeMapping with(java.util.function.Consumer<SqlTypeMappingBuilder> consumer) {
            SqlTypeMappingBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public SqlTypeMapping withJdbcType(JDBCType jdbcType) {
            return new SqlTypeMapping(jdbcType, this.baseType(), this.accessorSuffix(), this.specialCase(), this.isNullable(), this.componentType(), this.componentDbType());
        }

        default public SqlTypeMapping withBaseType(Class<?> baseType) {
            return new SqlTypeMapping(this.jdbcType(), baseType, this.accessorSuffix(), this.specialCase(), this.isNullable(), this.componentType(), this.componentDbType());
        }

        default public SqlTypeMapping withAccessorSuffix(String accessorSuffix) {
            return new SqlTypeMapping(this.jdbcType(), this.baseType(), accessorSuffix, this.specialCase(), this.isNullable(), this.componentType(), this.componentDbType());
        }

        default public SqlTypeMapping withSpecialCase(boolean specialCase) {
            return new SqlTypeMapping(this.jdbcType(), this.baseType(), this.accessorSuffix(), specialCase, this.isNullable(), this.componentType(), this.componentDbType());
        }

        default public SqlTypeMapping withIsNullable(boolean isNullable) {
            return new SqlTypeMapping(this.jdbcType(), this.baseType(), this.accessorSuffix(), this.specialCase(), isNullable, this.componentType(), this.componentDbType());
        }

        default public SqlTypeMapping withComponentType(SqlTypeMapping componentType) {
            return new SqlTypeMapping(this.jdbcType(), this.baseType(), this.accessorSuffix(), this.specialCase(), this.isNullable(), componentType, this.componentDbType());
        }

        default public SqlTypeMapping withComponentDbType(String componentDbType) {
            return new SqlTypeMapping(this.jdbcType(), this.baseType(), this.accessorSuffix(), this.specialCase(), this.isNullable(), this.componentType(), componentDbType);
        }

        default public <R> R map(Function<R> proc) {
            return proc.apply(this.jdbcType(), this.baseType(), this.accessorSuffix(), this.specialCase(), this.isNullable(), this.componentType(), this.componentDbType());
        }

        default public void accept(Consumer proc) {
            proc.apply(this.jdbcType(), this.baseType(), this.accessorSuffix(), this.specialCase(), this.isNullable(), this.componentType(), this.componentDbType());
        }

        @FunctionalInterface
        public static interface Function<R> {
            public R apply(JDBCType var1, Class<?> var2, String var3, boolean var4, boolean var5, SqlTypeMapping var6, String var7);
        }

        @FunctionalInterface
        public static interface Consumer {
            public void apply(JDBCType var1, Class<?> var2, String var3, boolean var4, boolean var5, SqlTypeMapping var6, String var7);
        }
    }
}

