/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import com.karuslabs.utilitary.Logger;
import com.karuslabs.utilitary.type.TypeMirrors;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor14;
import javax.lang.model.util.Types;
import org.ethelred.kiwiproc.processor.KiwiTypeVisitor;
import org.ethelred.kiwiproc.processor.types.KiwiType;
import org.ethelred.kiwiproc.processor.types.ValidContainerType;
import org.jspecify.annotations.Nullable;

public class TypeUtils
extends TypeMirrors {
    private final Logger logger;

    public TypeUtils(Elements elements, Types types, Logger logger) {
        super(elements, types);
        this.logger = logger;
    }

    public boolean isRecord(TypeMirror type) {
        return this.isSubtype(type, this.type(Record.class));
    }

    public String packageName(TypeElement typeElement) {
        for (Element el = typeElement; el != null; el = el.getEnclosingElement()) {
            if (el.getKind() != ElementKind.PACKAGE) continue;
            return ((PackageElement)el).getQualifiedName().toString();
        }
        throw new IllegalArgumentException();
    }

    public String toString(TypeMirror type) {
        return (String)new ToStringVisitor().visit(type);
    }

    public @Nullable ValidContainerType containerType(DeclaredType t) {
        for (ValidContainerType ct : ValidContainerType.values()) {
            if (!TypeUtils.is((TypeMirror)t, ct.javaType())) continue;
            return ct;
        }
        return null;
    }

    public boolean isSameType(TypeMirror t1, TypeMirror t2) {
        boolean result = super.isSameType(t1, t2);
        return result;
    }

    public List<? extends RecordComponentElement> recordComponents(DeclaredType t) {
        return Objects.requireNonNull(this.asTypeElement(t)).getRecordComponents();
    }

    public boolean isBoxed(DeclaredType t) {
        try {
            this.unboxedType(t);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isNullable(DeclaredType t) {
        List<? extends AnnotationMirror> annotations = t.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!annotationMirror.getAnnotationType().toString().endsWith("Nullable")) continue;
            return true;
        }
        return false;
    }

    public KiwiType kiwiType(TypeMirror type) {
        return type.accept(new KiwiTypeVisitor(this), null);
    }

    public String fqcn(DeclaredType t) {
        TypeElement te = (TypeElement)t.asElement();
        return te.getQualifiedName().toString();
    }

    public String packageName(DeclaredType t) {
        return this.packageName((TypeElement)t.asElement());
    }

    public String className(DeclaredType t) {
        TypeElement te = (TypeElement)t.asElement();
        return te.getSimpleName().toString();
    }

    class ToStringVisitor
    extends SimpleTypeVisitor14<String, Void> {
        ToStringVisitor() {
        }

        @Override
        protected String defaultAction(TypeMirror e, Void unused) {
            throw new UnsupportedOperationException(String.valueOf(e));
        }

        @Override
        public String visitPrimitive(PrimitiveType t, Void unused) {
            return t.getKind().name().toLowerCase();
        }

        @Override
        public String visitArray(ArrayType t, Void unused) {
            return (String)this.visit(t.getComponentType()) + "[]";
        }

        @Override
        public String visitDeclared(DeclaredType t, Void unused) {
            TypeElement te = (TypeElement)t.asElement();
            if ("java.lang".equals(TypeUtils.this.packageName(te))) {
                return te.getSimpleName().toString();
            }
            return String.valueOf(t);
        }

        @Override
        public String visitNoType(NoType t, Void unused) {
            if (t.getKind() == TypeKind.VOID) {
                return "void";
            }
            throw new UnsupportedOperationException(String.valueOf(t));
        }
    }
}

