/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor;

import com.karuslabs.utilitary.Logger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import org.ethelred.kiwiproc.meta.ColumnMetaData;
import org.ethelred.kiwiproc.processor.Conversion;
import org.ethelred.kiwiproc.processor.CoreTypes;
import org.ethelred.kiwiproc.processor.MethodParameterInfo;
import org.ethelred.kiwiproc.processor.QueryMethodKind;
import org.ethelred.kiwiproc.processor.SqlTypeMapping;
import org.ethelred.kiwiproc.processor.types.ContainerType;
import org.ethelred.kiwiproc.processor.types.KiwiType;
import org.ethelred.kiwiproc.processor.types.PrimitiveKiwiType;
import org.ethelred.kiwiproc.processor.types.RecordType;
import org.ethelred.kiwiproc.processor.types.RecordTypeComponent;
import org.ethelred.kiwiproc.processor.types.SqlArrayType;
import org.ethelred.kiwiproc.processor.types.ValidContainerType;
import org.ethelred.kiwiproc.processor.types.VoidType;

public record TypeValidator(Logger logger, Element element, CoreTypes coreTypes, boolean debug) {
    private static final KiwiType UPDATE_RETURN_TYPE = new PrimitiveKiwiType("int", false);
    private static final KiwiType BATCH_RETURN_TYPE = new ContainerType(ValidContainerType.ARRAY, UPDATE_RETURN_TYPE);

    public TypeValidator(Logger logger, Element methodElement, boolean debug) {
        this(logger, methodElement, new CoreTypes(), debug);
    }

    public boolean validateParameters(Map<ColumnMetaData, MethodParameterInfo> parameterMapping, QueryMethodKind kind) {
        boolean result = true;
        for (Map.Entry<ColumnMetaData, MethodParameterInfo> entry : parameterMapping.entrySet()) {
            ColumnMetaData columnMetaData = entry.getKey();
            MethodParameterInfo methodParameterInfo = entry.getValue();
            KiwiType parameterType = methodParameterInfo.type();
            if (kind == QueryMethodKind.BATCH && parameterType instanceof ContainerType) {
                ContainerType containerType = (ContainerType)parameterType;
                parameterType = containerType.containedType();
            }
            VariableElement element = methodParameterInfo.variableElement();
            KiwiType columnType = SqlTypeMapping.get(columnMetaData).kiwiType();
            if (this.withElement(element).validateSingleParameter(parameterType, columnType)) continue;
            result = false;
        }
        if (kind == QueryMethodKind.BATCH && parameterMapping.values().stream().map(MethodParameterInfo::type).anyMatch(t -> t instanceof ContainerType)) {
            result = false;
            this.logger.error(this.element, (Object)"SqlBatch method must have at least one iterable parameter");
        }
        return result;
    }

    private TypeValidator withElement(Element element) {
        return new TypeValidator(this.logger, element, this.coreTypes, this.debug);
    }

    private boolean validateSingleParameter(KiwiType parameterType, KiwiType columnType) {
        if (!this.validateGeneral(parameterType)) {
            this.logger.error(this.element, (Object)"Unsupported type %s for parameter %s".formatted(parameterType, this.simpleName()));
            return false;
        }
        if (!this.validateCompatible(parameterType, columnType)) {
            this.logger.error(this.element, (Object)"Parameter type %s is not compatible with SQL type %s for parameter %s".formatted(parameterType, columnType, this.simpleName()));
            return false;
        }
        return true;
    }

    private CharSequence simpleName() {
        return this.element.getSimpleName();
    }

    private boolean validateCompatible(KiwiType source, KiwiType target) {
        ContainerType containerType;
        if (source.equals(target)) {
            return true;
        }
        this.debug("Comparing %s with %s".formatted(source, target));
        Conversion c = this.coreTypes.lookup(source, target);
        if (c.isValid()) {
            if (c.hasWarning()) {
                this.warn(Objects.requireNonNull(c.warning()));
            }
            return true;
        }
        if (target instanceof ContainerType) {
            ContainerType targetContainer = (ContainerType)target;
            return this.validateCompatible(source, targetContainer.containedType());
        }
        if (source instanceof ContainerType && (containerType = (ContainerType)source).type() == ValidContainerType.OPTIONAL && target.isSimple()) {
            return target.isNullable() && this.validateCompatible(containerType.containedType(), target);
        }
        return false;
    }

    private boolean validateGeneral(KiwiType type) {
        if (type.isSimple() || type instanceof VoidType) {
            return true;
        }
        if (type instanceof ContainerType) {
            ContainerType ct = (ContainerType)type;
            KiwiType contained = ct.containedType();
            return (contained instanceof RecordType || contained.isSimple()) && this.validateGeneral(contained);
        }
        if (type instanceof SqlArrayType) {
            SqlArrayType sqlArrayType = (SqlArrayType)type;
            KiwiType contained = sqlArrayType.containedType();
            return contained.isSimple() && this.validateGeneral(contained);
        }
        if (type instanceof RecordType) {
            RecordType rt = (RecordType)type;
            List<RecordTypeComponent> componentTypes = rt.components();
            return componentTypes.stream().allMatch(t -> t.type().isSimple());
        }
        return false;
    }

    private boolean reportError(String message) {
        this.logger.error(this.element, (Object)message);
        return false;
    }

    private void info(String message) {
        this.logger.note(this.element, message);
    }

    private void debug(String message) {
        if (this.debug) {
            this.info("DEBUG: " + message);
        }
    }

    private void warn(String message) {
        this.logger.warn(this.element, message);
    }

    public boolean validateReturn(List<ColumnMetaData> columnMetaDataList, KiwiType returnType, QueryMethodKind kind) {
        if (returnType instanceof VoidType && kind != QueryMethodKind.QUERY) {
            return true;
        }
        if (returnType instanceof VoidType) {
            return this.reportError("Why would you want to return void from a query?");
        }
        if (kind == QueryMethodKind.UPDATE) {
            return this.validateCompatible(UPDATE_RETURN_TYPE, returnType) || this.reportError("Return type %s is invalid for SqlUpdate. Must be compatible with int".formatted(returnType));
        }
        if (kind == QueryMethodKind.BATCH) {
            return this.validateCompatible(BATCH_RETURN_TYPE, returnType) || this.reportError("Return type %s is invalid for SqlBatch. Must be compatible with int[]".formatted(returnType));
        }
        if (returnType instanceof ContainerType) {
            ContainerType containerType = (ContainerType)returnType;
            this.debug("Return type Container %s.%s".formatted(containerType.packageName(), containerType.className()));
            return this.validateReturn(columnMetaDataList, containerType.containedType(), kind);
        }
        if (columnMetaDataList.size() == 1 && returnType.isSimple()) {
            this.debug("Return type simple %s.%s".formatted(returnType.packageName(), returnType.className()));
            ColumnMetaData firstColumnMetaData = columnMetaDataList.get(0);
            KiwiType columnType = SqlTypeMapping.get(firstColumnMetaData).kiwiType();
            return this.validateCompatible(columnType, returnType);
        }
        if (returnType instanceof RecordType) {
            RecordType recordType = (RecordType)returnType;
            this.debug("Return type record %s.%s".formatted(recordType.packageName(), recordType.className()));
            List<RecordTypeComponent> components = recordType.components();
            return columnMetaDataList.stream().allMatch(columnMetaData -> {
                RecordTypeComponent matchingComponent = components.stream().filter(targetComponent -> columnMetaData.name().equivalent(targetComponent.name())).findFirst().orElse(null);
                if (matchingComponent == null) {
                    return this.reportError("Record '%s' does not have a component matching column '%s'".formatted(recordType.className(), columnMetaData.name()));
                }
                KiwiType columnType = SqlTypeMapping.get(columnMetaData).kiwiType();
                return this.validateCompatible(columnType, matchingComponent.type()) || this.reportError("Incompatible component type %s for column %s type %s".formatted(matchingComponent, columnMetaData.name(), columnType));
            }) && components.stream().allMatch(component -> {
                ColumnMetaData matchingColumn = columnMetaDataList.stream().filter(columnMetaData -> columnMetaData.name().equivalent(component.name())).findFirst().orElse(null);
                if (matchingColumn == null) {
                    return this.reportError("Record component '%s.%s' does not have a matching column".formatted(recordType.className(), component.name()));
                }
                KiwiType columnType = SqlTypeMapping.get(matchingColumn).kiwiType();
                return this.validateCompatible(columnType, component.type()) || this.reportError("Missing or incompatible column type %s for component %s type %s".formatted(columnType, component.name(), component.type()));
            });
        }
        return false;
    }
}

