/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor.generator;

import com.karuslabs.utilitary.Logger;
import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.CodeBlock;
import com.palantir.javapoet.JavaFile;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterSpec;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.ethelred.kiwiproc.processor.AssignmentConversion;
import org.ethelred.kiwiproc.processor.Conversion;
import org.ethelred.kiwiproc.processor.CoreTypes;
import org.ethelred.kiwiproc.processor.DAOClassInfo;
import org.ethelred.kiwiproc.processor.DAOMethodInfo;
import org.ethelred.kiwiproc.processor.DAOResultColumn;
import org.ethelred.kiwiproc.processor.FromSqlArrayConversion;
import org.ethelred.kiwiproc.processor.NullableSourceConversion;
import org.ethelred.kiwiproc.processor.QueryMethodKind;
import org.ethelred.kiwiproc.processor.StringFormatConversion;
import org.ethelred.kiwiproc.processor.ToSqlArrayConversion;
import org.ethelred.kiwiproc.processor.TypeMapping;
import org.ethelred.kiwiproc.processor.generator.ElementSupplier;
import org.ethelred.kiwiproc.processor.generator.KiwiTypeConverter;
import org.ethelred.kiwiproc.processor.generator.RuntimeTypes;
import org.ethelred.kiwiproc.processor.types.ContainerType;
import org.ethelred.kiwiproc.processor.types.KiwiType;
import org.ethelred.kiwiproc.processor.types.PrimitiveKiwiType;
import org.ethelred.kiwiproc.processor.types.VoidType;

public class InstanceGenerator {
    private final Logger logger;
    private final KiwiTypeConverter kiwiTypeConverter;
    private final CoreTypes coreTypes;
    private final Set<String> parameterNames = new HashSet<String>();
    private final Map<String, String> patchedNames = new HashMap<String, String>();
    private int patchedNameCount = 0;

    public InstanceGenerator(Logger logger, KiwiTypeConverter kiwiTypeConverter, CoreTypes coreTypes) {
        this.logger = logger;
        this.kiwiTypeConverter = kiwiTypeConverter;
        this.coreTypes = coreTypes;
    }

    public JavaFile generate(DAOClassInfo classInfo) {
        ClassName daoName = ClassName.get((String)classInfo.packageName(), (String)classInfo.daoName(), (String[])new String[0]);
        ParameterizedTypeName superClass = ParameterizedTypeName.get((ClassName)RuntimeTypes.ABSTRACT_DAO, (TypeName[])new TypeName[]{daoName});
        MethodSpec constructorSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)RuntimeTypes.DAO_CONTEXT, (String)"daoContext", (Modifier[])new Modifier[0]).build()).addStatement("super(daoContext)", new Object[0]).build();
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((ClassName)ClassName.get((String)classInfo.packageName(), (String)classInfo.className("Impl"), (String[])new String[0])).addOriginatingElement((Element)classInfo.element()).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)"javax.annotation.processing.Generated")).addMember("value", "$S", new Object[]{"org.ethelred.kiwiproc.processor.KiwiProcessor"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)superClass).addSuperinterface((TypeName)daoName).addMethod(constructorSpec);
        for (DAOMethodInfo methodThing : classInfo.methods()) {
            typeSpecBuilder.addMethod(this.buildMethod(methodThing));
        }
        return JavaFile.builder((String)classInfo.packageName(), (TypeSpec)typeSpecBuilder.build()).build();
    }

    private MethodSpec buildMethod(DAOMethodInfo methodInfo) {
        this.parameterNames.clear();
        this.patchedNames.clear();
        this.patchedNameCount = 0;
        MethodSpec.Builder methodSpecBuilder = MethodSpec.overriding((ExecutableElement)methodInfo.methodElement());
        methodSpecBuilder.addStatement("var connection = context.getConnection()", new Object[0]);
        methodSpecBuilder.beginControlFlow("try (var statement = connection.prepareStatement($S))", new Object[]{methodInfo.parsedSql().parsedSql()});
        methodSpecBuilder.addCode(switch (methodInfo.kind()) {
            default -> throw new IncompatibleClassChangeError();
            case QueryMethodKind.QUERY -> this.queryMethodBody(methodInfo);
            case QueryMethodKind.UPDATE -> this.updateMethodBody(methodInfo);
            case QueryMethodKind.BATCH -> this.batchMethodBody(methodInfo);
            case QueryMethodKind.DEFAULT -> throw new IllegalArgumentException();
        });
        methodSpecBuilder.nextControlFlow("catch ($T e)", new Object[]{SQLException.class}).addStatement("throw new $T(e)", new Object[]{RuntimeTypes.UNCHECKED_SQL_EXCEPTION}).endControlFlow();
        return methodSpecBuilder.build();
    }

    private CodeBlock updateMethodBody(DAOMethodInfo methodInfo) {
        CodeBlock.Builder builder = this.builderWithParameters(methodInfo);
        builder.addStatement("var rawResult = statement.executeUpdate()", new Object[0]);
        KiwiType returnType = methodInfo.signature().returnType();
        if (!(returnType instanceof VoidType)) {
            Conversion conversion = this.lookupConversion(methodInfo::methodElement, new TypeMapping(new PrimitiveKiwiType("int", false), returnType));
            this.buildConversion(builder, conversion, returnType, "result", "rawResult", true);
            builder.addStatement("return result", new Object[0]);
        }
        return builder.build();
    }

    private CodeBlock batchMethodBody(DAOMethodInfo methodInfo) {
        return CodeBlock.of((String)"//TODO\n", (Object[])new Object[0]);
    }

    private CodeBlock queryMethodBody(DAOMethodInfo methodInfo) {
        CodeBlock.Builder builder = this.builderWithParameters(methodInfo);
        String listVariable = this.patchName("l");
        TypeName componentClass = this.kiwiTypeConverter.fromKiwiType(methodInfo.resultComponentType());
        builder.addStatement("var rs = statement.executeQuery()", new Object[0]).addStatement("$T<$T> $L = new $T<>()", new Object[]{List.class, componentClass, listVariable, ArrayList.class}).beginControlFlow("$L (rs.next())", new Object[]{methodInfo.singleResult() ? "if" : "while"});
        DAOResultColumn singleColumn = methodInfo.singleColumn();
        List<DAOResultColumn> multipleColumns = methodInfo.multipleColumns();
        if (singleColumn != null) {
            TypeMapping mapping = singleColumn.asTypeMapping();
            Conversion conversion = this.lookupConversion(methodInfo::methodElement, mapping);
            builder.addStatement("var rawValue = rs.get$L($S)", new Object[]{singleColumn.sqlTypeMapping().accessorSuffix(), singleColumn.name()});
            this.buildConversion(builder, conversion, mapping.target(), "value", "rawValue", true);
        } else if (!multipleColumns.isEmpty()) {
            multipleColumns.forEach(daoResultColumn -> {
                Conversion conversion = this.lookupConversion(methodInfo::methodElement, daoResultColumn.asTypeMapping());
                String rawName = daoResultColumn.name() + "Raw";
                String accessorSuffix = daoResultColumn.sqlTypeMapping().accessorSuffix();
                TypeName typeName = this.kiwiTypeConverter.fromKiwiType(daoResultColumn.sqlTypeMapping().kiwiType());
                if ("Object".equals(accessorSuffix)) {
                    builder.addStatement("$1T $2L = rs.getObject($3S, $1T.class)", new Object[]{typeName, rawName, daoResultColumn.name()});
                } else {
                    builder.addStatement("$T $L = rs.get$L($S)", new Object[]{typeName, rawName, accessorSuffix, daoResultColumn.name()});
                }
                if (daoResultColumn.sqlTypeMapping().isNullable()) {
                    builder.beginControlFlow("if (rs.wasNull())", new Object[0]).addStatement("$L = null", new Object[]{rawName}).endControlFlow();
                }
                String varName = this.patchName(daoResultColumn.name().name());
                this.buildConversion(builder, conversion, daoResultColumn.asTypeMapping().target(), varName, rawName, true);
            });
            CodeBlock params = (CodeBlock)multipleColumns.stream().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{this.patchedNames.get(p.name().name())})).collect(CodeBlock.joining((String)",\n"));
            params = CodeBlock.builder().indent().add(params).unindent().build();
            builder.add("var value = new $T(\n$L\n);\n", new Object[]{componentClass, params});
        } else {
            throw new IllegalStateException("Expected singleColumn or multipleColumns");
        }
        builder.addStatement("$L.add(value)", new Object[]{listVariable}).endControlFlow();
        KiwiType kiwiType = methodInfo.signature().returnType();
        if (kiwiType instanceof ContainerType) {
            ContainerType containerType = (ContainerType)kiwiType;
            builder.add("return ", new Object[0]).addNamed(containerType.type().fromListTemplate(), Map.of("componentClass", componentClass, "listVariable", listVariable)).addStatement("", new Object[0]);
        } else {
            builder.addStatement("return $1L.isEmpty() ? null : $1L.get(0)", new Object[]{listVariable});
        }
        return builder.build();
    }

    private CodeBlock.Builder builderWithParameters(DAOMethodInfo methodInfo) {
        CodeBlock.Builder builder = CodeBlock.builder();
        methodInfo.parameterMapping().forEach(parameterInfo -> {
            String name = "param" + parameterInfo.index();
            Conversion conversion = this.lookupConversion(parameterInfo::element, parameterInfo.mapper());
            this.buildConversion(builder, conversion, parameterInfo.mapper().target(), name, parameterInfo.javaAccessor(), true);
            boolean nullableSource = parameterInfo.mapper().source().isNullable();
            if (nullableSource) {
                builder.beginControlFlow("if ($L == null)", new Object[]{name}).addStatement("statement.setNull($L, $L)", new Object[]{parameterInfo.index(), parameterInfo.sqlType()}).nextControlFlow("else", new Object[0]);
            }
            builder.addStatement("statement.$L($L, $L)", new Object[]{parameterInfo.setter(), parameterInfo.index(), name});
            if (nullableSource) {
                builder.endControlFlow();
            }
            this.parameterNames.add(parameterInfo.javaAccessor());
        });
        return builder;
    }

    private void buildConversion(CodeBlock.Builder builder, Conversion conversion, KiwiType targetType, String assignee, String accessor, boolean withVar) {
        try {
            CodeBlock insertVar;
            CodeBlock codeBlock = insertVar = withVar ? CodeBlock.of((String)"$T ", (Object[])new Object[]{this.kiwiTypeConverter.fromKiwiType(targetType)}) : CodeBlock.of((String)"", (Object[])new Object[0]);
            if (conversion instanceof AssignmentConversion) {
                builder.addStatement("$L$L = $L", new Object[]{insertVar, assignee, accessor});
            } else if (conversion instanceof StringFormatConversion) {
                StringFormatConversion sfc = (StringFormatConversion)conversion;
                builder.add("$L$L =", new Object[]{insertVar, assignee}).addStatement(sfc.conversionFormat(), sfc.withAccessor(accessor));
            } else if (conversion instanceof ToSqlArrayConversion) {
                ToSqlArrayConversion sac = (ToSqlArrayConversion)conversion;
                Conversion elementConversion = sac.elementConversion();
                String elementObjects = this.patchName("elementObjects");
                String lambdaValue = this.patchName("value");
                builder.add("Object[] $L = ", new Object[]{elementObjects}).addNamed(sac.ct().type().toStreamTemplate(), Map.of("containerVariable", accessor)).indent().add("\n.map($L -> {\n", new Object[]{lambdaValue}).indent();
                this.buildConversion(builder, elementConversion, sac.sat().containedType(), "tmp", lambdaValue, true);
                builder.addStatement("return tmp", new Object[0]).unindent().add("})\n.toArray();\n", new Object[0]).unindent();
                builder.addStatement("$L$L = connection.createArrayOf($S, $L)", new Object[]{insertVar, assignee, sac.sat().componentDbType(), elementObjects});
            } else if (conversion instanceof FromSqlArrayConversion) {
                FromSqlArrayConversion sac = (FromSqlArrayConversion)conversion;
                String arrayRS = this.patchName("arrayRS");
                String arrayList = this.patchName("arrayList");
                String rawItemValue = this.patchName("rawItemValue");
                String itemValue = this.patchName("itemValue");
                TypeName componentClass = this.kiwiTypeConverter.fromKiwiType(sac.ct().containedType());
                builder.addStatement("$T $L = $L.getResultSet()", new Object[]{ResultSet.class, arrayRS, accessor}).addStatement("List<$T> $L = new $T<>()", new Object[]{componentClass, arrayList, ArrayList.class}).beginControlFlow("while ($L.next())", new Object[]{arrayRS}).addStatement("var $L = $L.get$L(2)", new Object[]{rawItemValue, arrayRS, sac.sat().componentType().accessorSuffix()});
                this.buildConversion(builder, sac.elementConversion(), sac.ct().containedType(), itemValue, rawItemValue, true);
                builder.addStatement("$L.add($L)", new Object[]{arrayList, itemValue}).endControlFlow().add("$L$L = ", new Object[]{insertVar, assignee}).addNamed(sac.ct().type().fromListTemplate(), Map.of("componentClass", componentClass, "listVariable", arrayList)).addStatement("", new Object[0]);
            } else if (conversion instanceof NullableSourceConversion) {
                NullableSourceConversion nsc = (NullableSourceConversion)conversion;
                builder.addStatement("$T $L = null", new Object[]{this.kiwiTypeConverter.fromKiwiType(targetType), assignee}).beginControlFlow("if ($L != null)", new Object[]{accessor});
                this.buildConversion(builder, nsc.conversion(), targetType, assignee, accessor, false);
                builder.endControlFlow();
            } else {
                this.logger.error(null, (Object)"Unsupported Conversion %s".formatted(conversion));
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error in conversion " + conversion, e);
        }
    }

    private String patchName(String name) {
        return this.patchedNames.computeIfAbsent(name, k -> {
            Object newName = k;
            while (this.parameterNames.contains(newName)) {
                newName = k + ++this.patchedNameCount;
            }
            return newName;
        });
    }

    Conversion lookupConversion(ElementSupplier elementSupplier, TypeMapping t) {
        Element element = elementSupplier.getElement();
        Conversion conversion = this.coreTypes.lookup(t);
        if (!conversion.isValid()) {
            this.logger.error(element, (Object)"No valid conversion for %s".formatted(t));
        }
        if (conversion.hasWarning()) {
            this.logger.warn(element, conversion.warning());
        }
        return conversion;
    }
}

