/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor.generator;

import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import java.util.Map;
import org.ethelred.kiwiproc.processor.types.ContainerType;
import org.ethelred.kiwiproc.processor.types.KiwiType;
import org.ethelred.kiwiproc.processorconfig.DependencyInjectionStyle;

public class KiwiTypeConverter {
    private final Map<DependencyInjectionStyle, DependencyInjectionTypes> dependencyInjectionTypesMap = Map.of(DependencyInjectionStyle.JAKARTA, new DependencyInjectionTypes(ClassName.get((String)"jakarta.inject", (String)"Singleton", (String[])new String[0]), ClassName.get((String)"jakarta.inject", (String)"Named", (String[])new String[0])));

    public TypeName fromKiwiType(KiwiType kiwiType) {
        if (kiwiType instanceof ContainerType) {
            ContainerType containerType = (ContainerType)kiwiType;
            return ParameterizedTypeName.get((ClassName)ClassName.get(containerType.type().javaType()), (TypeName[])new TypeName[]{this.fromKiwiType(containerType.containedType())});
        }
        return ClassName.get((String)kiwiType.packageName(), (String)kiwiType.className(), (String[])new String[0]);
    }

    DependencyInjectionTypes getDependencyInjectionType(DependencyInjectionStyle dependencyInjectionStyle) {
        DependencyInjectionTypes result = this.dependencyInjectionTypesMap.get(dependencyInjectionStyle);
        if (result == null) {
            throw new IllegalArgumentException("Missing annotation types for " + dependencyInjectionStyle);
        }
        return result;
    }

    record DependencyInjectionTypes(ClassName singleton, ClassName named) {
    }
}

