/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor.generator;

import com.karuslabs.utilitary.Logger;
import com.palantir.javapoet.JavaFile;
import java.io.IOException;
import javax.annotation.processing.Filer;
import org.ethelred.kiwiproc.processor.CoreTypes;
import org.ethelred.kiwiproc.processor.DAOClassInfo;
import org.ethelred.kiwiproc.processor.DAOGenerator;
import org.ethelred.kiwiproc.processor.generator.ElementSupplier;
import org.ethelred.kiwiproc.processor.generator.InstanceGenerator;
import org.ethelred.kiwiproc.processor.generator.KiwiTypeConverter;
import org.ethelred.kiwiproc.processor.generator.ProviderGenerator;
import org.ethelred.kiwiproc.processorconfig.DependencyInjectionStyle;

public class PoetDAOGenerator
implements DAOGenerator {
    private final Logger logger;
    private final Filer filer;
    private final DependencyInjectionStyle dependencyInjectionStyle;
    private final KiwiTypeConverter kiwiTypeConverter;
    private final InstanceGenerator instanceGenerator;
    private final ProviderGenerator providerGenerator;
    private final CoreTypes coreTypes;

    public PoetDAOGenerator(Logger logger, Filer filer, DependencyInjectionStyle dependencyInjectionStyle) {
        this.logger = logger;
        this.filer = filer;
        this.dependencyInjectionStyle = dependencyInjectionStyle;
        this.kiwiTypeConverter = new KiwiTypeConverter();
        this.coreTypes = new CoreTypes();
        this.instanceGenerator = new InstanceGenerator(logger, this.kiwiTypeConverter, this.coreTypes);
        this.providerGenerator = new ProviderGenerator(dependencyInjectionStyle, this.kiwiTypeConverter);
    }

    @Override
    public void generateProvider(DAOClassInfo classInfo) {
        JavaFile javaFile = this.providerGenerator.generate(classInfo);
        this.writeJavaFile(classInfo::element, javaFile);
    }

    @Override
    public void generateImpl(DAOClassInfo classInfo) {
        JavaFile javaFile = this.instanceGenerator.generate(classInfo);
        this.writeJavaFile(classInfo::element, javaFile);
    }

    private void writeJavaFile(ElementSupplier elementSupplier, JavaFile javaFile) {
        javaFile = javaFile.toBuilder().skipJavaLangImports(true).indent("    ").addFileComment("GENERATED CODE - DO NOT EDIT", new Object[0]).build();
        try {
            this.logger.note(elementSupplier.getElement(), "Generating " + javaFile.typeSpec().name());
            javaFile.writeTo(this.filer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

