/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor.generator;

import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.JavaFile;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterSpec;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.sql.DataSource;
import org.ethelred.kiwiproc.processor.DAOClassInfo;
import org.ethelred.kiwiproc.processor.DAOMethodInfo;
import org.ethelred.kiwiproc.processor.Signature;
import org.ethelred.kiwiproc.processor.generator.KiwiTypeConverter;
import org.ethelred.kiwiproc.processor.generator.RuntimeTypes;
import org.ethelred.kiwiproc.processor.types.VoidType;
import org.ethelred.kiwiproc.processorconfig.DependencyInjectionStyle;

public class ProviderGenerator {
    private final DependencyInjectionStyle dependencyInjectionStyle;
    private final KiwiTypeConverter kiwiTypeConverter;

    public ProviderGenerator(DependencyInjectionStyle dependencyInjectionStyle, KiwiTypeConverter kiwiTypeConverter) {
        this.dependencyInjectionStyle = dependencyInjectionStyle;
        this.kiwiTypeConverter = kiwiTypeConverter;
    }

    public JavaFile generate(DAOClassInfo classInfo) {
        ClassName daoName = ClassName.get((String)classInfo.packageName(), (String)classInfo.daoName(), (String[])new String[0]);
        ParameterizedTypeName superClass = ParameterizedTypeName.get((ClassName)RuntimeTypes.ABSTRACT_PROVIDER, (TypeName[])new TypeName[]{daoName});
        MethodSpec constructorSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(DataSource.class, (String)"dataSource", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)this.kiwiTypeConverter.getDependencyInjectionType(this.dependencyInjectionStyle).named()).addMember("value", "$S", new Object[]{classInfo.dataSourceName()}).build()).build()).addStatement("super(dataSource)", new Object[0]).build();
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((ClassName)ClassName.get((String)classInfo.packageName(), (String)classInfo.className("Provider"), (String[])new String[0])).addOriginatingElement((Element)classInfo.element()).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)"javax.annotation.processing.Generated")).addMember("value", "$S", new Object[]{"org.ethelred.kiwiproc.processor.KiwiProcessor"}).build()).addAnnotation(this.kiwiTypeConverter.getDependencyInjectionType(this.dependencyInjectionStyle).singleton()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)superClass).addSuperinterface((TypeName)daoName).addMethod(constructorSpec);
        MethodSpec withContextMethod = MethodSpec.methodBuilder((String)"withContext").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)RuntimeTypes.DAO_CONTEXT, (String)"daoContext", (Modifier[])new Modifier[0]).build()).returns((TypeName)daoName).addStatement("return new $L(daoContext)", new Object[]{classInfo.className("Impl")}).build();
        typeSpecBuilder.addMethod(withContextMethod);
        for (DAOMethodInfo methodThing : classInfo.methods()) {
            typeSpecBuilder.addMethod(this.buildMethod(methodThing));
        }
        return JavaFile.builder((String)classInfo.packageName(), (TypeSpec)typeSpecBuilder.build()).build();
    }

    private MethodSpec buildMethod(DAOMethodInfo methodInfo) {
        MethodSpec.Builder builder = MethodSpec.overriding((ExecutableElement)methodInfo.methodElement());
        Signature signature = methodInfo.signature();
        String params = String.join((CharSequence)", ", signature.paramNames());
        if (signature.returnType() instanceof VoidType) {
            builder.addStatement("run(dao -> dao.$L($L))", new Object[]{signature.methodName(), params});
        } else {
            builder.addStatement("return call(dao -> dao.$L($L))", new Object[]{signature.methodName(), params});
        }
        return builder.build();
    }
}

