/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.processor.types;

import org.ethelred.kiwiproc.processor.CoreTypes;
import org.ethelred.kiwiproc.processor.types.KiwiType;

public record PrimitiveKiwiType(String primitiveName, boolean isNullable) implements KiwiType
{
    public PrimitiveKiwiType {
        if (!CoreTypes.primitiveToBoxedStrings.containsKey(primitiveName)) {
            throw new IllegalArgumentException("Unknown primitive " + primitiveName);
        }
    }

    @Override
    public String packageName() {
        if (this.isNullable) {
            return "java.lang";
        }
        return "";
    }

    @Override
    public String className() {
        if (this.isNullable) {
            return CoreTypes.primitiveToBoxedStrings.get(this.primitiveName);
        }
        return this.primitiveName;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public KiwiType withIsNullable(boolean b) {
        return new PrimitiveKiwiType(this.primitiveName, b);
    }

    @Override
    public String toString() {
        return this.primitiveName + (this.isNullable ? "/nullable" : "/non-null");
    }
}

