/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.meta;

import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Objects;
import org.ethelred.kiwiproc.meta.ArrayComponent;
import org.ethelred.kiwiproc.meta.SqlName;
import org.jspecify.annotations.Nullable;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.TypeInfo;

public record ColumnMetaData(int index, SqlName name, boolean nullable, JDBCType sqlType, @Nullable ArrayComponent componentType) {
    public ColumnMetaData(int index, String name, boolean nullable, JDBCType sqlType, @Nullable ArrayComponent componentType) {
        this(index, new SqlName(name), nullable, sqlType, componentType);
    }

    public static ColumnMetaData from(Connection connection, int index, ResultSetMetaData resultSetMetaData) throws SQLException {
        return new ColumnMetaData(index, new SqlName(resultSetMetaData.getColumnName(index)), resultSetMetaData.isNullable(index) != 0, JDBCType.valueOf(resultSetMetaData.getColumnType(index)), ColumnMetaData.componentType(connection, resultSetMetaData.getColumnType(index), resultSetMetaData.getColumnTypeName(index)));
    }

    private static @Nullable ArrayComponent componentType(Connection connection, int columnType, String columnTypeName) {
        if (columnType != 2003) {
            return null;
        }
        try {
            BaseConnection pgConnection = connection.unwrap(BaseConnection.class);
            TypeInfo typeInfo = pgConnection.getTypeInfo();
            int oid = typeInfo.getPGType(columnTypeName);
            int componentOid = typeInfo.getPGArrayElement(oid);
            return new ArrayComponent(JDBCType.valueOf(typeInfo.getSQLType(componentOid)), Objects.requireNonNull(typeInfo.getPGType(componentOid)));
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static ColumnMetaData from(Connection connection, int index, ParameterMetaData parameterMetaData) throws SQLException {
        return new ColumnMetaData(index, SqlName.PARAMETER, parameterMetaData.isNullable(index) != 0, JDBCType.valueOf(parameterMetaData.getParameterType(index)), ColumnMetaData.componentType(connection, parameterMetaData.getParameterType(index), parameterMetaData.getParameterTypeName(index)));
    }
}

