/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.meta;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.ethelred.kiwiproc.meta.ColumnMetaData;
import org.ethelred.kiwiproc.meta.QueryMetaData;
import org.ethelred.kiwiproc.meta.QueryMetaDataBuilder;
import org.ethelred.kiwiproc.processorconfig.DataSourceConfig;
import org.jspecify.annotations.Nullable;
import org.postgresql.ds.PGSimpleDataSource;

public class DatabaseWrapper {
    private static final Pattern SQL_EXCEPTION_POSITION = Pattern.compile("Position: (\\d+)", 8);
    private @Nullable Boolean valid;
    private DatabaseWrapperException error;
    private DataSource dataSource;

    public DatabaseWrapper(String name, @Nullable DataSourceConfig dataSourceConfig) {
        if (dataSourceConfig == null) {
            this.valid = false;
            this.error = new DatabaseWrapperException("No config found for data source name %s".formatted(name));
        } else if (this.invalidDriver(dataSourceConfig.driverClassName())) {
            this.valid = false;
            this.error = new DatabaseWrapperException("Sorry, I only support Postgres at the moment.");
        } else {
            PGSimpleDataSource pgSimpleDataSource = new PGSimpleDataSource();
            pgSimpleDataSource.setDatabaseName(dataSourceConfig.database());
            pgSimpleDataSource.setURL(dataSourceConfig.url());
            pgSimpleDataSource.setUser(dataSourceConfig.username());
            pgSimpleDataSource.setPassword(dataSourceConfig.password());
            this.dataSource = pgSimpleDataSource;
        }
    }

    private boolean invalidDriver(@Nullable String driverClassName) {
        return driverClassName != null && !driverClassName.isBlank() && !"org.postgresql.Driver".equals(driverClassName);
    }

    public boolean isValid() {
        if (this.valid == null) {
            this.testConnection();
        }
        return this.valid;
    }

    public DatabaseWrapperException getError() {
        return this.error;
    }

    Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public QueryMetaData getQueryMetaData(String sql) throws SQLException {
        System.err.printf("getQueryMetaData(%s)%n", sql);
        try (Connection connection = this.getConnection();){
            QueryMetaData queryMetaData;
            block18: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    QueryMetaDataBuilder builder = QueryMetaDataBuilder.builder();
                    ResultSetMetaData rsmd = statement.getMetaData();
                    if (rsmd != null) {
                        for (int index = 1; index <= rsmd.getColumnCount(); ++index) {
                            builder.addResultColumns(ColumnMetaData.from(connection, index, rsmd));
                        }
                    }
                    ParameterMetaData pmd = statement.getParameterMetaData();
                    for (int index = 1; index <= pmd.getParameterCount(); ++index) {
                        builder.addParameters(ColumnMetaData.from(connection, index, pmd));
                    }
                    queryMetaData = builder.build();
                    if (statement == null) break block18;
                }
                catch (Throwable builder) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable rsmd) {
                            builder.addSuppressed(rsmd);
                        }
                    }
                    throw builder;
                }
                statement.close();
            }
            return queryMetaData;
        }
        catch (SQLException e) {
            Matcher matcher = SQL_EXCEPTION_POSITION.matcher(e.getMessage());
            if (matcher.find()) {
                int position = Integer.parseInt(matcher.group(1));
                String newMessage = this.insertPosition(position, sql, e.getMessage());
                throw new SQLException(newMessage, e);
            }
            throw e;
        }
    }

    private String insertPosition(int position, String sql, String message) {
        StringBuilder buf = new StringBuilder();
        int accumulatedSqlLength = 0;
        int lastLineLength = 0;
        for (String line : sql.split("\\R")) {
            int before = accumulatedSqlLength;
            lastLineLength = line.length();
            buf.append(line).append("\n");
            if (before > position || (accumulatedSqlLength += line.length() + 1) < position) continue;
            buf.append(" ".repeat(position - before - 1)).append("^").append("\n");
        }
        if (position > accumulatedSqlLength) {
            buf.append(" ".repeat(lastLineLength)).append("^\n");
        }
        buf.append(message);
        return buf.toString();
    }

    private void testConnection() {
        try (Connection connection = this.getConnection();
             PreparedStatement st = connection.prepareStatement("SELECT 1 = 1");
             ResultSet rs = st.executeQuery();){
            this.valid = rs.next();
        }
        catch (SQLException e) {
            this.valid = false;
            this.error = new DatabaseWrapperException("Test database connection failed", e);
        }
    }

    public static class DatabaseWrapperException
    extends Exception {
        public DatabaseWrapperException(String message) {
            super(message);
        }

        public DatabaseWrapperException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

