/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.kiwiproc.meta;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record ParsedQuery(String rawSql, String parsedSql, List<String> parameterNames) {
    private static final Pattern PARAMETER_REGEX = Pattern.compile("([^:\\\\]*)((?<![:]):([a-zA-Z0-9_]+))([^:]*)");

    public static ParsedQuery parse(String rawSql) {
        StringBuilder parsedSql = new StringBuilder();
        ArrayList<String> indices = new ArrayList<String>();
        Matcher matcher = PARAMETER_REGEX.matcher(rawSql);
        int i = 0;
        while (matcher.find()) {
            parsedSql.append(matcher.group(1));
            parsedSql.append("?");
            parsedSql.append(matcher.group(4));
            String parameterName = matcher.group(3);
            indices.add(parameterName);
            ++i;
        }
        if (indices.isEmpty()) {
            return new ParsedQuery(rawSql, rawSql, List.of());
        }
        return new ParsedQuery(rawSql, parsedSql.toString(), List.copyOf(indices));
    }
}

