/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.picocli.defaults;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Function;
import picocli.CommandLine;

public class EnvironmentDefaultValueProvider
implements CommandLine.IDefaultValueProvider {
    @VisibleForTesting
    protected static Function<String, String> envLoader = System::getenv;

    public String defaultValue(CommandLine.Model.ArgSpec argSpec) throws Exception {
        if (argSpec.isOption()) {
            CommandLine.Model.OptionSpec option = (CommandLine.Model.OptionSpec)argSpec;
            CommandLine.Model.CommandSpec command = option.command();
            String name = this._normalize(command.name() + "-" + option.longestName());
            return envLoader.apply(name);
        }
        return null;
    }

    private String _normalize(String input) {
        return input.toUpperCase().replaceAll("^\\W*", "").replaceAll("\\W+", "_");
    }
}

