/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.collect;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class BiMap<A, B> {
    private final Map<A, B> first;
    private final Map<B, A> second;

    public BiMap(Map<A, B> map) {
        this(map.entrySet().stream().map(mapEntry -> BiMap.entry(mapEntry.getKey(), mapEntry.getValue())).collect(Collectors.toList()), map.size());
    }

    private BiMap(Iterable<Entry<A, B>> entries, int size) {
        this.first = new HashMap<A, B>(size);
        this.second = new HashMap<B, A>(size);
        entries.forEach(e -> {
            Object a = e.a;
            Object b = e.b;
            if (this.first.containsKey(Objects.requireNonNull(a)) || this.second.containsKey(Objects.requireNonNull(b))) {
                throw new IllegalArgumentException(String.format("Duplicate value in (%s, %s)", a, b));
            }
            this.first.put(a, b);
            this.second.put(b, a);
        });
    }

    public int size() {
        return this.first.size();
    }

    public Optional<B> getByA(A key) {
        return Optional.ofNullable(this.first.get(key));
    }

    public Optional<A> getByB(B key) {
        return Optional.ofNullable(this.second.get(key));
    }

    public static <A, B> Entry<A, B> entry(A a, B b) {
        return new Entry<A, B>(Objects.requireNonNull(a), Objects.requireNonNull(b));
    }

    public static <A, B> BiMap<A, B> ofEntries(Iterable<Entry<A, B>> entries) {
        return new BiMap<A, B>(entries, 0);
    }

    public static <A, B> BiMap<A, B> ofEntries(Collection<Entry<A, B>> entries) {
        return new BiMap<A, B>(entries, entries.size());
    }

    @SafeVarargs
    public static <A, B> BiMap<A, B> ofEntries(Entry<A, B> ... entries) {
        return new BiMap<A, B>(List.of(entries), entries.length);
    }

    public static class Entry<A, B> {
        private final A a;
        private final B b;

        private Entry(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }
}

