/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;

public class Sequences {
    private Sequences() {
    }

    public static <T> List<List<T>> prefixes(Iterable<T> iterable) {
        ArrayList<T> acc = new ArrayList<T>();
        ArrayList<List<T>> r = new ArrayList<List<T>>();
        r.add(List.of());
        for (T item : iterable) {
            acc.add(item);
            r.add(List.copyOf(acc));
        }
        return r;
    }

    public static <T, C extends Collection<T>> C concat(Collection<? extends T> a, Collection<? extends T> b, IntFunction<C> collectionSupplier) {
        Collection result = (Collection)collectionSupplier.apply(a.size() + b.size());
        result.addAll(a);
        result.addAll(b);
        return (C)result;
    }

    public static <T> List<T> concat(List<? extends T> a, List<? extends T> b) {
        return Sequences.concat(a, b, ArrayList::new);
    }

    @SafeVarargs
    public static <T> List<T> concat(List<? extends T> list, T ... items) {
        return Sequences.concat(list, List.of(items));
    }

    public static <T> List<T> head(List<T> list, int items) {
        if (items == 0) {
            return List.of();
        }
        if (Math.abs(items) >= list.size()) {
            return list;
        }
        if (items > 0) {
            return list.subList(0, items);
        }
        return list.subList(0, list.size() + items);
    }

    public static <T> List<T> tail(List<T> list, int items) {
        if (items == 0) {
            return List.of();
        }
        if (Math.abs(items) >= list.size()) {
            return list;
        }
        if (items > 0) {
            return list.subList(list.size() - items, list.size());
        }
        return list.subList(-items, list.size());
    }
}

