/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.function;

import org.ethelred.util.function.WrappedCheckedException;

@FunctionalInterface
public interface CheckedRunnable<E extends Throwable> {
    public void run() throws E;

    default public Runnable asUnchecked() {
        return () -> {
            try {
                this.run();
            }
            catch (Throwable e) {
                throw new WrappedCheckedException(e);
            }
        };
    }

    public static <EE extends Throwable> Runnable unchecked(CheckedRunnable<EE> runnable) {
        return runnable.asUnchecked();
    }
}

