/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.collect;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.ethelred.util.collect.TypedObjectKey;
import org.ethelred.util.collect.TypedObjectMap;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ImmutableTypedObjectMap
implements TypedObjectMap {
    private final Map<TypedObjectKey<?>, Object> map;

    private ImmutableTypedObjectMap(Map<TypedObjectKey<?>, Object> map) {
        this.map = Map.copyOf(map);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> Optional<T> get(TypedObjectKey<T> key) {
        return Optional.ofNullable(this.map.get(key));
    }

    public static class Builder {
        private final Map<TypedObjectKey<?>, Object> innerBuilder = new LinkedHashMap();

        public <T> Builder put(TypedObjectKey<T> key, T value) {
            this.innerBuilder.put(key, value);
            return this;
        }

        public Builder set(TypedObjectKey<Boolean> flag) {
            return this.put(flag, true);
        }

        public ImmutableTypedObjectMap build() {
            return new ImmutableTypedObjectMap(this.innerBuilder);
        }
    }
}

