/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.function;

import java.util.function.Consumer;
import org.ethelred.util.function.WrappedCheckedException;

public interface CheckedConsumer<T, E extends Throwable> {
    public void accept(T var1) throws E;

    default public Consumer<T> asUnchecked() {
        return t -> {
            try {
                this.accept(t);
            }
            catch (Throwable e) {
                throw new WrappedCheckedException(e);
            }
        };
    }

    public static <TT, EE extends Throwable> Consumer<TT> unchecked(CheckedConsumer<TT, EE> checkedConsumer) {
        return checkedConsumer.asUnchecked();
    }
}

