/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.function;

import java.util.function.Function;
import org.ethelred.util.function.WrappedCheckedException;

public interface CheckedFunction<T, R, E extends Throwable> {
    public R apply(T var1) throws E;

    default public Function<T, R> asUnchecked() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Throwable e) {
                throw new WrappedCheckedException(e);
            }
        };
    }

    public static <TT, RR, EE extends Throwable> Function<TT, RR> unchecked(CheckedFunction<TT, RR, EE> checkedFunction) {
        return checkedFunction.asUnchecked();
    }
}

