/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.stream;

import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collector;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class SummaryStatistics<T> {
    private final Comparator<T> comparator;
    private int count;
    private @Nullable T min;
    private @Nullable T max;

    private SummaryStatistics(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public static <A extends Comparable<? super A>> Collector<A, ?, SummaryStatistics<A>> collector() {
        return SummaryStatistics.collector(Comparator.naturalOrder());
    }

    public static <B> Collector<B, ?, SummaryStatistics<B>> collector(Comparator<B> comparator) {
        return Collector.of(() -> new SummaryStatistics(comparator), SummaryStatistics::add, SummaryStatistics::combine, new Collector.Characteristics[0]);
    }

    private void add(T t) {
        ++this.count;
        this._min(t);
        this._max(t);
    }

    private void _max(@Nullable T t) {
        if (t == null) {
            return;
        }
        if (this.max == null || this.comparator.compare(t, this.max) > 0) {
            this.max = t;
        }
    }

    private void _min(@Nullable T t) {
        if (t == null) {
            return;
        }
        if (this.min == null || this.comparator.compare(t, this.min) < 0) {
            this.min = t;
        }
    }

    private SummaryStatistics<T> combine(SummaryStatistics<T> other) {
        this.count += other.count;
        this._min(other.min);
        this._max(other.max);
        return this;
    }

    public Optional<T> getMin() {
        return Optional.ofNullable(this.min);
    }

    public Optional<T> getMax() {
        return Optional.ofNullable(this.max);
    }

    public int getCount() {
        return this.count;
    }
}

