/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.collect;

public interface TypedObjectKey<T> {
    public static <T> TypedObjectKey<T> identity() {
        return new IdentityTypedObjectKey();
    }

    public static <V, T> TypedObjectKey<T> valued(V value) {
        return new ValuedTypedObjectKey(value);
    }

    public static class ValuedTypedObjectKey<V, TT>
    implements TypedObjectKey<TT> {
        private V value;

        ValuedTypedObjectKey(V value) {
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValuedTypedObjectKey other = (ValuedTypedObjectKey)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static class IdentityTypedObjectKey<TT>
    implements TypedObjectKey<TT> {
    }
}

