/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.function;

import java.util.function.Supplier;
import org.ethelred.util.function.WrappedCheckedException;

@FunctionalInterface
public interface CheckedSupplier<T, E extends Throwable> {
    public T get() throws E;

    default public Supplier<T> asUnchecked() {
        return () -> {
            try {
                return this.get();
            }
            catch (Throwable e) {
                throw new WrappedCheckedException(e);
            }
        };
    }

    public static <TT, EE extends Throwable> Supplier<TT> unchecked(CheckedSupplier<TT, EE> supplier) {
        return supplier.asUnchecked();
    }
}

