/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.function;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class Lazy<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private boolean got = false;
    private boolean inGet = false;
    private T value;

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <V> Lazy<V> lazy(Supplier<V> supplier) {
        return new Lazy<V>(Objects.requireNonNull(supplier));
    }

    public static <V, A> Lazy<V> lazy(A argument, Function<A, V> initializer) {
        Objects.requireNonNull(initializer);
        return new Lazy<Object>(() -> initializer.apply(argument));
    }

    public static <V, A> Lazy<V> lazy(Supplier<A> argument, Function<A, V> initializer) {
        Objects.requireNonNull(argument);
        Objects.requireNonNull(initializer);
        return new Lazy<Object>(() -> initializer.apply(argument.get()));
    }

    @Override
    public T get() {
        if (this.inGet) {
            throw new IllegalStateException("Cycle in Lazy.get()");
        }
        if (!this.got) {
            this.got = true;
            this.inGet = true;
            this.value = this.supplier.get();
            this.inGet = false;
        }
        return this.value;
    }
}

