/*
 * Decompiled with CFR 0.152.
 */
package org.etourdot.xincproc.xinclude;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class EncodingUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";

    private EncodingUtils() {
    }

    public static Charset getCharset(InputStream inputStream) throws IOException {
        long computed;
        byte[] buffer = new byte[192];
        int reading = ByteStreams.read((InputStream)inputStream, (byte[])buffer, (int)0, (int)192);
        Charset resultCharset = 4 > reading ? Charset.forName(DEFAULT_ENCODING) : (65279L == (computed = (long)(0xFF000000 & buffer[0] << 24 | 0xFF0000 & buffer[1] << 16 | 0xFF00 & buffer[2] << 8 | 0xFF & buffer[3])) || 0xFFFE0000L == computed ? Charset.forName("UCS-4") : (60L == computed ? Charset.forName("UCS-4BE") : (0x3C000000L == computed ? Charset.forName("UCS-4LE") : (3932223L == computed ? Charset.forName("UTF-16BE") : (1006649088L == computed ? Charset.forName("UTF-16LE") : (1010792557L == computed || 1282385812L == computed ? EncodingUtils.getXmlCharsetEncoding(buffer) : (0xFEFF0000L == (computed & 0xFFFF0000L) ? Charset.forName("UTF-16") : (0xFFFE0000L == (computed & 0xFFFF0000L) ? Charset.forName("UTF-16") : Charset.forName(DEFAULT_ENCODING)))))))));
        return resultCharset;
    }

    private static Charset getXmlCharsetEncoding(byte ... input) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader streamReader = factory.createXMLStreamReader(new ByteArrayInputStream(input));
            String guessEncoding = streamReader.getEncoding();
            if (null == guessEncoding) {
                return Charset.forName(DEFAULT_ENCODING);
            }
            return Charset.forName(guessEncoding);
        }
        catch (XMLStreamException xMLStreamException) {
            return Charset.forName(DEFAULT_ENCODING);
        }
    }
}

