/*
 * Decompiled with CFR 0.152.
 */
package org.etourdot.xincproc.xinclude.sax;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.etourdot.xincproc.xinclude.exceptions.XIncludeFatalException;

class DocType {
    private Optional<String> doctype = Optional.absent();
    private Optional<String> publicId = Optional.absent();
    private Optional<String> systemId = Optional.absent();
    private ImmutableList<Element> elements = ImmutableList.of();
    private ImmutableMap<String, ImmutableList<Attribute>> attributes = ImmutableMap.of();
    private ImmutableList<ExternalEntity> externalEntities = ImmutableList.of();
    private ImmutableList<InternalEntity> internalEntities = ImmutableList.of();
    private ImmutableMap<String, UnparsedEntity> unparsedEntities = ImmutableMap.of();

    DocType() {
    }

    static DocType copy(DocType docTypeToCopy) {
        DocType newDocType = new DocType();
        newDocType.doctype = docTypeToCopy.doctype;
        newDocType.publicId = docTypeToCopy.publicId;
        newDocType.systemId = docTypeToCopy.systemId;
        newDocType.elements = ImmutableList.copyOf(docTypeToCopy.elements);
        newDocType.attributes = ImmutableMap.copyOf(docTypeToCopy.attributes);
        newDocType.externalEntities = ImmutableList.copyOf(docTypeToCopy.externalEntities);
        newDocType.internalEntities = ImmutableList.copyOf(docTypeToCopy.internalEntities);
        newDocType.unparsedEntities = ImmutableMap.copyOf(docTypeToCopy.unparsedEntities);
        return newDocType;
    }

    private void outputElements(StringBuilder docTypeBuffer) {
        for (Element element : this.elements) {
            docTypeBuffer.append("<!ELEMENT ").append(element.getName()).append(' ').append(element.getValue()).append('>');
            this.outputAttributes(docTypeBuffer, element);
        }
    }

    private void outputAttributes(StringBuilder docTypeBuffer, Element element) {
        ImmutableList attributesList = (ImmutableList)this.attributes.get((Object)element.getName());
        if (null != attributesList && !attributesList.isEmpty()) {
            docTypeBuffer.append("<!ATTLIST ").append(element.getName()).append(' ');
            for (Attribute attribute : attributesList) {
                docTypeBuffer.append(attribute.getaName()).append(' ').append(attribute.getType()).append(' ').append(attribute.getMode()).append(' ').append(Strings.nullToEmpty((String)attribute.getValue()));
            }
            docTypeBuffer.append('>');
        }
    }

    private void outputExternalEntities(StringBuilder docTypeBuffer) {
        for (ExternalEntity externalEntity : this.externalEntities) {
            docTypeBuffer.append("<!NOTATION ").append(externalEntity.getName()).append(' ').append(externalEntity.getPublicId()).append(' ').append(externalEntity.getSystemId()).append('>');
        }
    }

    private void outputInternalEntities(StringBuilder docTypeBuffer) {
        for (InternalEntity internalEntity : this.internalEntities) {
            docTypeBuffer.append("<!ENTITY ").append(internalEntity.getName()).append(' ').append(internalEntity.getValue()).append('>');
        }
    }

    DocType setDoctype(String doctype) {
        this.doctype = Optional.fromNullable((Object)doctype);
        return this;
    }

    DocType setPublicId(String publicId) {
        this.publicId = Optional.fromNullable((Object)publicId);
        return this;
    }

    DocType setSystemId(String systemId) {
        this.systemId = Optional.fromNullable((Object)systemId);
        return this;
    }

    DocType addElement(String name, String model) {
        this.elements = new ImmutableList.Builder().addAll(this.elements).add((Object)new Element(name, model)).build();
        return this;
    }

    DocType addAttribute(String eName, String aName, String type, String mode, String value) {
        Attribute newAttribute = new Attribute(aName, type, mode, value);
        ImmutableList.Builder listAttributeBuilder = new ImmutableList.Builder();
        if (null != this.attributes.get((Object)eName)) {
            listAttributeBuilder.addAll((Iterable)this.attributes.get((Object)eName));
        }
        listAttributeBuilder.add((Object)newAttribute);
        this.attributes = new ImmutableMap.Builder().put((Object)eName, (Object)listAttributeBuilder.build()).build();
        return this;
    }

    DocType addExternalEntity(String name, String publicId, String systemId) {
        this.externalEntities = new ImmutableList.Builder().addAll(this.externalEntities).add((Object)new ExternalEntity(name, publicId, systemId)).build();
        return this;
    }

    DocType addInternalEntity(String name, String value) {
        this.internalEntities = new ImmutableList.Builder().addAll(this.internalEntities).add((Object)new InternalEntity(name, value)).build();
        return this;
    }

    DocType addUnparsedEntity(String name, String publicId, String systemId, String notationName) throws XIncludeFatalException {
        UnparsedEntity unparsedEntity = (UnparsedEntity)this.unparsedEntities.get((Object)name);
        if (null != unparsedEntity && null != systemId && !systemId.equals(unparsedEntity.getSystemId())) {
            throw new XIncludeFatalException("duplicate unparsed entity");
        }
        this.unparsedEntities = new ImmutableMap.Builder().put((Object)name, (Object)new UnparsedEntity(notationName, publicId, systemId)).build();
        return this;
    }

    String getDocTypeValue() {
        StringBuilder docTypeBuffer = new StringBuilder();
        if (this.doctype.isPresent()) {
            docTypeBuffer.append("<!DOCTYPE ").append((String)this.doctype.get());
            if (this.systemId.isPresent()) {
                if (this.publicId.isPresent()) {
                    docTypeBuffer.append("PUBLIC \"").append((String)this.publicId.get()).append("\" \"").append((String)this.systemId.get()).append('\"');
                } else {
                    docTypeBuffer.append("SYSTEM \"").append((String)this.systemId.get()).append('\"');
                }
            }
            if (!this.elements.isEmpty()) {
                docTypeBuffer.append(" [");
                this.outputElements(docTypeBuffer);
                this.outputInternalEntities(docTypeBuffer);
                this.outputExternalEntities(docTypeBuffer);
                docTypeBuffer.append(']');
            }
            docTypeBuffer.append('>');
        }
        return docTypeBuffer.toString();
    }

    private static final class UnparsedEntity {
        private final String publicId;
        private final String systemId;
        private final String notationName;

        private UnparsedEntity(String notationName, String publicId, String systemId) {
            this.notationName = notationName;
            this.publicId = publicId;
            this.systemId = systemId;
        }

        String getSystemId() {
            return this.systemId;
        }
    }

    private static final class Attribute {
        private final String aName;
        private final String type;
        private final String mode;
        private final String value;

        private Attribute(String aName, String type, String mode, String value) {
            this.aName = aName;
            this.type = type;
            this.mode = mode;
            this.value = value;
        }

        String getaName() {
            return this.aName;
        }

        String getMode() {
            return this.mode;
        }

        String getType() {
            return this.type;
        }

        String getValue() {
            return this.value;
        }
    }

    private static final class InternalEntity {
        private final String name;
        private final String value;

        private InternalEntity(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }
    }

    private static final class ExternalEntity {
        private final String name;
        private final String publicId;
        private final String systemId;

        private ExternalEntity(String name, String publicId, String systemId) {
            this.name = name;
            this.publicId = publicId;
            this.systemId = systemId;
        }

        String getName() {
            return this.name;
        }

        String getPublicId() {
            return this.publicId;
        }

        String getSystemId() {
            return this.systemId;
        }
    }

    private static final class Element {
        private final String name;
        private final String value;

        private Element(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }
    }
}

