/*
 * Decompiled with CFR 0.152.
 */
package org.etourdot.xincproc.xinclude.sax;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.etourdot.xincproc.xinclude.exceptions.XIncludeFatalException;
import org.etourdot.xincproc.xinclude.exceptions.XIncludeResourceException;
import org.etourdot.xincproc.xinclude.sax.XIncludeConstants;
import org.xml.sax.Attributes;

class XIncludeAttributes {
    private static final ImmutableList<String> VALID_PARSE = ImmutableList.of((Object)"text", (Object)"xml");
    private Optional<URI> href = Optional.absent();
    private Optional<String> parse = Optional.absent();
    private Optional<String> xpointer = Optional.absent();
    private Optional<String> encoding = Optional.absent();
    private Optional<String> accept = Optional.absent();
    private Optional<String> acceptLanguage = Optional.absent();
    private Optional<URI> base = Optional.absent();

    XIncludeAttributes(Attributes attributes) throws XIncludeFatalException, XIncludeResourceException {
        this.fillAttributes(attributes);
        this.checkingAttributes();
    }

    private static boolean checkVal(String val) {
        byte[] bytes;
        for (byte aByte : bytes = val.getBytes()) {
            if (32 <= aByte && 126 >= aByte) continue;
            return true;
        }
        return false;
    }

    private void checkingAttributes() throws XIncludeFatalException, XIncludeResourceException {
        if (this.href.isPresent()) {
            if (this.getHref().toASCIIString().contains("#")) {
                throw new XIncludeFatalException("Fragment identifiers must not be used.");
            }
        } else if (this.parse.isPresent() && this.isXmlParse() && Strings.isNullOrEmpty((String)this.getXPointer())) {
            throw new XIncludeFatalException("If the href attribute is absent when parse=\"xml\", the xpointer attribute must be present.");
        }
        if (this.isTextParse()) {
            if (this.xpointer.isPresent()) {
                throw new XIncludeFatalException("The xpointer attribute must not be present when parse=\"text\"");
            }
            try {
                if (this.encoding.isPresent()) {
                    Charset.forName(this.getEncoding());
                }
            }
            catch (Exception ignored) {
                throw new XIncludeResourceException("Encoding attribute should be a valid encoding name");
            }
        }
        if (this.accept.isPresent() && XIncludeAttributes.checkVal(this.getAccept())) {
            throw new XIncludeFatalException("Attribute \"Accept\" containing characters outside the range #x20 through #x7E");
        }
        if (this.acceptLanguage.isPresent() && XIncludeAttributes.checkVal(this.getAcceptLanguage())) {
            throw new XIncludeFatalException("Attribute \"AcceptLanguage\" containing characters outside the range #x20 through #x7E");
        }
    }

    private void fillAttributes(Attributes attributes) throws XIncludeFatalException {
        Optional hrefAtt = Optional.fromNullable((Object)attributes.getValue(XIncludeConstants.ATT_HREF.getLocalPart()));
        try {
            this.href = hrefAtt.isPresent() && !Strings.isNullOrEmpty((String)((String)hrefAtt.get())) ? Optional.of((Object)new URI((String)hrefAtt.get())) : Optional.absent();
        }
        catch (URISyntaxException ignored) {
            throw new XIncludeFatalException("Href must be a valid URI");
        }
        this.parse = Optional.fromNullable((Object)attributes.getValue(XIncludeConstants.ATT_PARSE.getLocalPart()));
        if (this.parse.isPresent() && !VALID_PARSE.contains(this.parse.get())) {
            throw new XIncludeFatalException("Parse value must be \"xml\" or \"text\".");
        }
        this.xpointer = Optional.fromNullable((Object)attributes.getValue(XIncludeConstants.ATT_XPOINTER.getLocalPart()));
        this.encoding = Optional.fromNullable((Object)attributes.getValue(XIncludeConstants.ATT_ENCODING.getLocalPart()));
        this.accept = Optional.fromNullable((Object)attributes.getValue(XIncludeConstants.ATT_ACCEPT.getLocalPart()));
        this.acceptLanguage = Optional.fromNullable((Object)attributes.getValue(XIncludeConstants.ATT_ACCEPT_LANGUAGE.getLocalPart()));
        Optional baseAtt = Optional.fromNullable((Object)attributes.getValue(XIncludeConstants.XMLBASE_QNAME.getNamespaceURI(), XIncludeConstants.XMLBASE_QNAME.getLocalPart()));
        try {
            this.base = baseAtt.isPresent() ? Optional.of((Object)new URI((String)baseAtt.get())) : Optional.absent();
        }
        catch (URISyntaxException ignored) {
            throw new XIncludeFatalException("Base must be a valid URI");
        }
    }

    String getAccept() {
        return (String)this.accept.orNull();
    }

    boolean isAcceptPresent() {
        return this.accept.isPresent();
    }

    String getAcceptLanguage() {
        return (String)this.acceptLanguage.orNull();
    }

    boolean isAcceptLanguagePresent() {
        return this.acceptLanguage.isPresent();
    }

    String getEncoding() {
        return (String)this.encoding.orNull();
    }

    boolean isEncodingPresent() {
        return this.encoding.isPresent();
    }

    URI getHref() {
        return (URI)this.href.orNull();
    }

    boolean isHrefPresent() {
        return this.href.isPresent();
    }

    boolean isXmlParse() {
        return !this.parse.isPresent() || "xml".equals(this.getParse());
    }

    String getXPointer() {
        return (String)this.xpointer.orNull();
    }

    boolean isXPointerPresent() {
        return this.xpointer.isPresent();
    }

    URI getBase() {
        return (URI)this.base.orNull();
    }

    boolean isBasePresent() {
        return this.base.isPresent();
    }

    String getParse() {
        return (String)this.parse.orNull();
    }

    boolean isTextParse() {
        return this.parse.isPresent() && "text".equals(this.getParse());
    }
}

