/*
 * Decompiled with CFR 0.152.
 */
package org.etourdot.xincproc.xinclude.sax;

import com.google.common.base.Optional;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.etourdot.xincproc.xinclude.XIncProcConfiguration;
import org.etourdot.xincproc.xinclude.exceptions.XIncludeFatalException;
import org.etourdot.xincproc.xinclude.sax.DocType;
import org.etourdot.xincproc.xinclude.sax.XIncludeConstants;
import org.xml.sax.Attributes;

public class XIncludeContext {
    private final XIncProcConfiguration configuration;
    private final Deque<URI> basesURIDeque = new ArrayDeque<URI>();
    private final Deque<String> xincludeDeque = new ArrayDeque<String>();
    private URI initialBaseURI;
    private Optional<URI> currentBaseURI = Optional.absent();
    private String language;
    private URI sourceURI;
    private URI hrefURI;
    private Exception currentException;
    private DocType docType = new DocType();

    public XIncludeContext(XIncProcConfiguration configuration) {
        this.configuration = configuration;
    }

    public static XIncludeContext newContext(XIncludeContext contextToCopy) {
        XIncludeContext newContext = new XIncludeContext(contextToCopy.configuration);
        newContext.currentBaseURI = contextToCopy.currentBaseURI;
        newContext.basesURIDeque.addAll(contextToCopy.basesURIDeque);
        newContext.language = contextToCopy.language;
        newContext.xincludeDeque.addAll(contextToCopy.xincludeDeque);
        newContext.docType = DocType.copy(contextToCopy.docType);
        return newContext;
    }

    public XIncProcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void updateContextWithElementAttributes(Attributes attributes) throws XIncludeFatalException {
        this.extractCurrentBaseURI(attributes);
        if (this.currentBaseURI.isPresent()) {
            this.addBaseURIPath((URI)this.currentBaseURI.get());
        }
    }

    public void updateContextWhenEndElement() {
        if (this.currentBaseURI.isPresent()) {
            this.removeBaseURIPath((URI)this.currentBaseURI.get());
            this.currentBaseURI = Optional.absent();
        }
    }

    public boolean isLanguageFixup() {
        return this.configuration.isLanguageFixup();
    }

    public boolean isBaseFixup() {
        return this.configuration.isBaseUrisFixup();
    }

    public URI getSourceURI() {
        return this.sourceURI;
    }

    public void setSourceURI(URI sourceURI) {
        this.sourceURI = sourceURI;
    }

    public Exception getCurrentException() {
        return this.currentException;
    }

    public void setCurrentException(Exception currentException) {
        this.currentException = currentException;
    }

    public void addInInclusionChain(URI path, String pointer) throws XIncludeFatalException {
        String xincludePath = path.toASCIIString() + (null != pointer ? '#' + pointer : "");
        if (this.xincludeDeque.contains(xincludePath)) {
            throw new XIncludeFatalException("Inclusion Loop on path: " + xincludePath);
        }
        this.xincludeDeque.addLast(xincludePath);
    }

    public void removeFromInclusionChain() {
        this.xincludeDeque.pollLast();
    }

    public URI getInitialBaseURI() {
        return this.initialBaseURI;
    }

    public void setInitialBaseURI(URI initialBaseURI) {
        this.initialBaseURI = initialBaseURI;
        this.currentBaseURI = Optional.absent();
        this.basesURIDeque.clear();
    }

    public void addBaseURIPath(URI basePath) {
        this.basesURIDeque.addLast(basePath);
    }

    public List<URI> getBaseURIPaths() {
        return new ArrayList<URI>(this.basesURIDeque);
    }

    public URI getCurrentBaseURI() {
        return (URI)this.currentBaseURI.orNull();
    }

    public URI getHrefURI() {
        return this.hrefURI;
    }

    public void setHrefURI(URI hrefURI) {
        this.hrefURI = hrefURI;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String toString() {
        return "sourceURI:" + this.sourceURI + "\n,currentBase:" + this.currentBaseURI.get() + ",hrefURI:" + this.hrefURI + "\n,lang:" + this.language;
    }

    private void extractCurrentBaseURI(Attributes attributes) throws XIncludeFatalException {
        URI foundURI;
        int baseAttIdx = attributes.getIndex("http://www.w3.org/XML/1998/namespace", XIncludeConstants.XMLBASE_QNAME.getLocalPart());
        if (0 <= baseAttIdx) {
            try {
                foundURI = new URI(attributes.getValue(baseAttIdx));
            }
            catch (URISyntaxException ignored) {
                throw new XIncludeFatalException("Invalid base URI");
            }
        } else {
            foundURI = null;
        }
        this.currentBaseURI = Optional.fromNullable(foundURI);
    }

    void removeBaseURIPath(URI basePath) {
        this.basesURIDeque.removeLastOccurrence(basePath);
    }

    String getDocType() {
        return this.docType.getDocTypeValue();
    }

    void setDocType(String name, String publicId, String systemId) {
        this.docType.setDoctype(name).setPublicId(publicId).setSystemId(systemId);
    }

    void addAttributeDoctype(String eName, String aName, String type, String mode, String value) {
        this.docType.addAttribute(eName, aName, type, mode, value);
    }

    void addElementDoctype(String name, String model) {
        this.docType.addElement(name, model);
    }

    void addExternalEntityDoctype(String name, String publicId, String systemId) {
        this.docType.addExternalEntity(name, publicId, systemId);
    }

    void addInternalEntityDoctype(String name, String value) {
        this.docType.addInternalEntity(name, value);
    }

    void addUnparsedEntityDoctype(String name, String publicId, String systemId, String notationName) throws XIncludeFatalException {
        this.docType.addUnparsedEntity(name, publicId, systemId, notationName);
    }
}

