/*
 * Decompiled with CFR 0.152.
 */
package org.etourdot.xincproc.xinclude;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.etourdot.xincproc.xinclude.EncodingUtils;
import org.etourdot.xincproc.xinclude.XIncProcConfiguration;
import org.etourdot.xincproc.xinclude.exceptions.XIncludeFatalException;
import org.etourdot.xincproc.xinclude.sax.XIncProcXIncludeFilter;
import org.etourdot.xincproc.xinclude.sax.XIncludeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XIncProcEngine {
    private static final Logger LOG = LoggerFactory.getLogger(XIncProcEngine.class);
    private static final XIncProcConfiguration CONFIGURATION = XIncProcConfiguration.newXIncProcConfiguration();
    private XIncProcConfiguration configuration;

    private XIncProcEngine() {
        this.configuration = CONFIGURATION;
    }

    protected XIncProcEngine(XIncProcConfiguration configuration) {
        this.configuration = configuration;
    }

    public static XMLFilter newXIncludeFilter(URI baseURI) {
        XIncludeContext context = new XIncludeContext(CONFIGURATION);
        context.setSourceURI(baseURI);
        context.setInitialBaseURI(baseURI);
        return XIncProcEngine.newXIncludeFilter(context);
    }

    public static XMLFilter newXIncludeFilter(XIncludeContext context) {
        return new XIncProcXIncludeFilter(context);
    }

    public static void parse(URI baseURI, OutputStream output) throws XIncludeFatalException {
        Processor processor = CONFIGURATION.getProcessor();
        XMLFilter filter = XIncProcEngine.newXIncludeFilter(baseURI);
        InputSource inputSource = new InputSource(baseURI.toASCIIString());
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            filter.setParent(xmlReader);
            SAXSource saxSource = new SAXSource(filter, inputSource);
            XdmNode node = processor.newDocumentBuilder().wrap((Object)saxSource);
            Serializer serializer = processor.newSerializer(output);
            processor.writeXdmValue((XdmValue)node, (Destination)serializer);
        }
        catch (SAXException e) {
            throw new XIncludeFatalException(e);
        }
        catch (SaxonApiException e) {
            throw new XIncludeFatalException((Exception)((Object)e));
        }
    }

    public static void parse(InputStream input, String systemId, OutputStream output) throws XIncludeFatalException, IOException {
        XIncProcXIncludeFilter filter;
        LOG.trace("parse:{}", (Object)systemId);
        Processor processor = CONFIGURATION.getProcessor();
        try {
            URI uri = new URI(systemId);
            filter = (XIncProcXIncludeFilter)XIncProcEngine.newXIncludeFilter(uri);
        }
        catch (URISyntaxException e) {
            throw new XIncludeFatalException(e);
        }
        byte[] inputBytes = ByteStreams.toByteArray((InputStream)input);
        InputSupplier supplier = ByteStreams.newInputStreamSupplier((byte[])inputBytes);
        Charset charset = EncodingUtils.getCharset((InputStream)supplier.getInput());
        InputSource inputSource = new InputSource((InputStream)supplier.getInput());
        inputSource.setSystemId(systemId);
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/resolve-dtd-uris", false);
            filter.setParent(xmlReader);
            SAXSource saxSource = new SAXSource(filter, inputSource);
            XdmNode node = processor.newDocumentBuilder().build((Source)saxSource);
            LOG.trace("parse result:{}", (Object)node.toString());
            XIncProcEngine.serializeNode(output, processor, filter, charset, node);
        }
        catch (SAXException e) {
            throw new XIncludeFatalException(e.getMessage());
        }
        catch (SaxonApiException e) {
            throw new XIncludeFatalException(e.getMessage());
        }
    }

    private static void serializeNode(OutputStream output, Processor processor, XIncProcXIncludeFilter filter, Charset charset, XdmNode node) throws IOException, SaxonApiException {
        output.write("<?xml version=\"1.0\" encoding=\"".getBytes());
        output.write(charset.displayName().getBytes());
        output.write("\"?>".getBytes());
        String docType = filter.getDoctype();
        if (!Strings.isNullOrEmpty((String)docType)) {
            output.write(docType.getBytes("UTF-8"));
        }
        Serializer serializer = processor.newSerializer(output);
        serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        serializer.setOutputProperty(Serializer.Property.ENCODING, charset.displayName());
        processor.writeXdmValue((XdmValue)node, (Destination)serializer);
    }

    public XIncProcConfiguration getConfiguration() {
        return this.configuration;
    }

    public static XIncProcConfiguration getUnderlyingConfiguration() {
        return CONFIGURATION;
    }
}

