/*
 * Decompiled with CFR 0.152.
 */
package org.etourdot.xincproc.xinclude;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.commons.io.input.BOMInputStream;
import org.etourdot.xincproc.xinclude.EncodingUtils;
import org.etourdot.xincproc.xinclude.exceptions.XIncludeFatalException;
import org.etourdot.xincproc.xinclude.exceptions.XIncludeResourceException;

public final class XIncProcUtils {
    public static final String XINCLUDE_NAMESPACE_URI = "http://www.w3.org/2001/XInclude";
    public static final QName FALLBACK_QNAME = new QName("http://www.w3.org/2001/XInclude", "fallback", "xi");
    public static final QName XINCLUDE_QNAME = new QName("http://www.w3.org/2001/XInclude", "include", "xi");

    private XIncProcUtils() {
    }

    public static boolean isXIncludeNamespace(QName qname) {
        return qname.getNamespaceURI().equals(XINCLUDE_NAMESPACE_URI);
    }

    public static boolean isXInclude(QName qname) {
        return XINCLUDE_QNAME.getLocalPart().equals(qname.getLocalPart()) && (Strings.isNullOrEmpty((String)qname.getNamespaceURI()) || XINCLUDE_QNAME.getNamespaceURI().equals(qname.getNamespaceURI()));
    }

    public static boolean isFallback(QName qname) {
        return FALLBACK_QNAME.getLocalPart().equals(qname.getLocalPart()) && (Strings.isNullOrEmpty((String)qname.getNamespaceURI()) || FALLBACK_QNAME.getNamespaceURI().equals(qname.getNamespaceURI()));
    }

    public static URI resolveBase(URI baseURI, Iterable<URI> uris) {
        URI resolvedUri = baseURI;
        for (URI uri : uris) {
            resolvedUri = baseURI.resolve(uri);
        }
        return resolvedUri;
    }

    public static URI resolveBase(URI baseURI, Stack<URI> stack) throws XIncludeFatalException {
        URI computedUri = XIncProcUtils.computeBase(stack);
        URI resolvedUri = baseURI.resolve(computedUri);
        if (0 == resolvedUri.compareTo(baseURI)) {
            throw new XIncludeFatalException("Inclusion loop error");
        }
        return resolvedUri;
    }

    public static String readTextURI(URI source, String encoding, String accept, String acceptLanguage) throws XIncludeFatalException, XIncludeResourceException {
        try {
            URL url = source.toURL();
            URLConnection urlConnection = url.openConnection();
            if (null != accept) {
                urlConnection.setRequestProperty("Accept", accept);
            }
            if (null != acceptLanguage) {
                urlConnection.setRequestProperty("Accept-Language", acceptLanguage);
            }
            InputStream urlInputStream = urlConnection.getInputStream();
            byte[] inputBytes = ByteStreams.toByteArray((InputStream)urlInputStream);
            urlInputStream.close();
            BOMInputStream bomInputStream = new BOMInputStream((InputStream)new ByteArrayInputStream(inputBytes));
            if (bomInputStream.hasBOM()) {
                InputStreamReader reader = new InputStreamReader(new BufferedInputStream((InputStream)bomInputStream));
                return CharStreams.toString((Readable)reader);
            }
            InputSupplier supplier = ByteStreams.newInputStreamSupplier((byte[])inputBytes);
            Charset charset = null == encoding ? EncodingUtils.getCharset((InputStream)supplier.getInput()) : Charset.forName(encoding);
            return CharStreams.toString((InputSupplier)CharStreams.newReaderSupplier((InputSupplier)supplier, (Charset)charset));
        }
        catch (MalformedURLException e) {
            throw new XIncludeFatalException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new XIncludeFatalException(e.getMessage());
        }
        catch (IOException e) {
            throw new XIncludeResourceException(e.getMessage());
        }
    }

    private static URI computeBase(Stack<URI> stack) {
        assert (!stack.isEmpty());
        Iterator it = stack.iterator();
        URI resultURI = (URI)it.next();
        while (it.hasNext()) {
            URI uri = (URI)it.next();
            resultURI = resultURI.resolve(uri);
        }
        return resultURI;
    }
}

