/*
 * Decompiled with CFR 0.152.
 */
package org.etourdot.xincproc.xinclude.sax;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.lang3.StringUtils;
import org.etourdot.xincproc.xinclude.XIncProcEngine;
import org.etourdot.xincproc.xinclude.XIncProcUtils;
import org.etourdot.xincproc.xinclude.exceptions.XIncludeFatalException;
import org.etourdot.xincproc.xinclude.exceptions.XIncludeResourceException;
import org.etourdot.xincproc.xinclude.sax.XIncludeAttributes;
import org.etourdot.xincproc.xinclude.sax.XIncludeConstants;
import org.etourdot.xincproc.xinclude.sax.XIncludeContext;
import org.etourdot.xincproc.xpointer.XPointerEngine;
import org.etourdot.xincproc.xpointer.exceptions.XPointerException;
import org.etourdot.xincproc.xpointer.exceptions.XPointerResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2Impl;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class XIncProcXIncludeFilter
extends XMLFilterImpl
implements DeclHandler,
LexicalHandler {
    private static final Logger LOG = LoggerFactory.getLogger(XIncProcXIncludeFilter.class);
    private static final String FIXUP_XML_LANG = "fixup-xml-lang";
    private static final String FIXUP_XML_BASE = "fixup-xml-base";
    private static final String LEXICALID = "http://xml.org/sax/properties/lexical-handler";
    private static final String DECLID = "http://xml.org/sax/properties/declaration-handler";
    private final XIncludeContext context;
    private final Stack<String> currentLangStack;
    private boolean inDTD;
    private boolean hasUnparserEntity;
    private Optional<LexicalHandler> lexicalHandler = Optional.absent();
    private boolean alreadyProceedFallback;
    private int elementLevel;
    private int fallbackLevel;
    private int xIncludeLevel;
    private int needFallbackLevel;
    private int injectingXIncludeLevel;

    public XIncProcXIncludeFilter(XIncludeContext context) {
        this.context = context;
        this.currentLangStack = new Stack();
        this.currentLangStack.push(context.getLanguage());
        this.injectingXIncludeLevel = 0;
        this.xIncludeLevel = 0;
        this.fallbackLevel = 0;
        this.setHasUnparserEntity(false);
    }

    public String getDoctype() {
        return this.context.getDocType();
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICALID.equals(name)) {
            this.lexicalHandler = Optional.fromNullable((Object)((LexicalHandler)value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public void parse(InputSource input) throws SAXException, IOException {
        XMLReader parent = this.getParent();
        if (null != parent) {
            parent.setProperty(LEXICALID, this);
            parent.setProperty(DECLID, this);
        }
        super.parse(input);
    }

    @Override
    public void startDocument() throws SAXException {
        this.elementLevel = 0;
        if (!this.isInjectingXInclude()) {
            LOG.trace("startDocument@{}", (Object)Integer.toHexString(this.hashCode()));
            super.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.isInjectingXInclude()) {
            LOG.trace("endDocument@{}", (Object)Integer.toHexString(this.hashCode()));
            super.endDocument();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        LOG.trace("startElement@{}: {}, {}, {}", new Object[]{Integer.toHexString(this.hashCode()), uri, localName, qName});
        AttributesImpl attributesImpl = new AttributesImpl(atts);
        this.context.updateContextWithElementAttributes(attributesImpl);
        QName elementQName = this.calculateElementName(uri, localName, qName);
        this.startingElement();
        if (XIncProcUtils.isXInclude(elementQName)) {
            this.startXIncludeElement(atts);
        } else if (XIncProcUtils.isFallback(elementQName)) {
            this.startFallbackElement();
        } else {
            if (!this.isInFallbackElement() && this.isNeedFallback()) {
                throw new XIncludeFatalException("No Fallback element");
            }
            if (this.isUsable()) {
                this.startCommonElement(uri, localName, qName, attributesImpl);
            } else if (XIncProcUtils.isXIncludeNamespace(elementQName)) {
                throw new XIncludeFatalException("Any element of XInclude namespace allowed into xinclude");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        LOG.trace("endElement@{}:{},{},{}", new Object[]{Integer.toHexString(this.hashCode()), uri, localName, qName});
        this.context.updateContextWhenEndElement();
        QName elementQName = new QName(uri, localName);
        if (XIncProcUtils.isFallback(elementQName)) {
            if (this.isNeedFallback()) {
                this.endingNeedFallback();
            }
            this.endingFallbackElement();
        } else if (XIncProcUtils.isXInclude(elementQName)) {
            if (this.isNeedFallback()) {
                this.endingNeedFallback();
                throw new XIncludeFatalException(this.context.getCurrentException());
            }
            this.context.removeFromInclusionChain();
            this.endingXIncludeElement();
        } else if (this.isUsable()) {
            if (!this.currentLangStack.empty()) {
                this.currentLangStack.pop();
            }
            super.endElement(uri, localName, qName);
        }
        this.endingElement();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isUsable()) {
            LOG.trace("characters@{}: {}", (Object)Integer.toHexString(this.hashCode()), (Object)new String(ch).substring(start, start + length).trim());
            super.characters(ch, start, length);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOG.trace("resolveEntity:{},{},{}", (Object)publicId, (Object)systemId);
        return super.resolveEntity(publicId, systemId);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        LOG.trace("setDocumentLocator");
        super.setDocumentLocator(new Locator2Impl(locator));
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        LOG.trace("skippedEntity:{}", (Object)name);
        this.setHasUnparserEntity(true);
        super.characters(('&' + name + ';').toCharArray(), 0, name.length() + 2);
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        LOG.trace("unparsedEntityDecl:{},{},{},{}", new Object[]{name, publicId, systemId, notationName});
        this.context.addUnparsedEntityDoctype(name, publicId, systemId, notationName);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equalsIgnoreCase(FIXUP_XML_LANG)) {
            this.context.getConfiguration().setConfigurationProperty("http://etourdot.org/xml/features/xinclude/fixup-language", value);
        } else if (name.equalsIgnoreCase(FIXUP_XML_BASE)) {
            this.context.getConfiguration().setConfigurationProperty("http://etourdot.org/xml/features/xinclude/fixup-base-uris", value);
        } else {
            super.setFeature(name, value);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!"http://www.w3.org/2001/XInclude".equals(uri)) {
            super.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.isUsable()) {
            super.processingInstruction(target, data);
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        LOG.trace("notationDecl:{},{},{}", new Object[]{name, publicId, systemId});
        super.notationDecl(name, publicId, systemId);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        LOG.trace("startDTD:{},{},{}", new Object[]{name, publicId, systemId});
        this.inDTD = true;
        if (this.lexicalHandler.isPresent()) {
            ((LexicalHandler)this.lexicalHandler.get()).startDTD(name, publicId, systemId);
        }
        this.context.setDocType(name, publicId, systemId);
    }

    @Override
    public void endDTD() throws SAXException {
        LOG.trace("endDTD");
        this.inDTD = false;
        if (this.lexicalHandler.isPresent()) {
            ((LexicalHandler)this.lexicalHandler.get()).endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        LOG.trace("startEntity:{}", (Object)name);
        if (this.lexicalHandler.isPresent()) {
            ((LexicalHandler)this.lexicalHandler.get()).startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        LOG.trace("endEntity:{}", (Object)name);
        if (this.lexicalHandler.isPresent()) {
            ((LexicalHandler)this.lexicalHandler.get()).endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        LOG.trace("startCDATA");
        if (this.lexicalHandler.isPresent()) {
            ((LexicalHandler)this.lexicalHandler.get()).startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        LOG.trace("endCDATA");
        if (this.lexicalHandler.isPresent()) {
            ((LexicalHandler)this.lexicalHandler.get()).endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        LOG.trace("comment: {}", (Object)new String(ch).substring(start, start + length));
        if (this.lexicalHandler.isPresent() && !this.inDTD && (!this.isInXIncludeElement() || this.isInjectingXInclude() || this.isInFallbackElement())) {
            ((LexicalHandler)this.lexicalHandler.get()).comment(ch, start, length);
        }
    }

    @Override
    public void elementDecl(String name, String model) throws SAXException {
        LOG.trace("elementDecl:{},{}", (Object)name, (Object)model);
        this.context.addElementDoctype(name, model);
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        LOG.trace("attributeDecl:{},{},{},{},{}", new Object[]{eName, aName, type, mode, value});
        this.context.addAttributeDoctype(eName, aName, type, mode, value);
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        LOG.trace("internalEntityDecl:{},{}", (Object)name, (Object)value);
        this.context.addInternalEntityDoctype(name, value);
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        LOG.trace("externalEntityDecl:{},{},{}", new Object[]{name, publicId, systemId});
        this.context.addExternalEntityDoctype(name, publicId, systemId);
    }

    public boolean isHasUnparserEntity() {
        return this.hasUnparserEntity;
    }

    public void setHasUnparserEntity(boolean hasUnparserEntity) {
        this.hasUnparserEntity = hasUnparserEntity;
    }

    private void includeXmlContent(XIncludeAttributes xIncludeAttributes) throws XIncludeFatalException, XIncludeResourceException {
        try {
            this.settingLanguage();
            SAXSource source = this.buildingXIncludeSource(xIncludeAttributes);
            DocumentInfo docInfo = this.context.getConfiguration().getProcessor().getUnderlyingConfiguration().buildDocument((Source)source);
            XdmNode node = new XdmNode((NodeInfo)docInfo);
            this.startingInjectXInclude();
            this.injectingXInclude(xIncludeAttributes, source, node);
        }
        catch (XPointerResourceException e) {
            throw new XIncludeResourceException(e.getMessage());
        }
        catch (XPointerException e) {
            throw new XIncludeFatalException(e.getMessage());
        }
        catch (XPathException e) {
            if (e.getCause() instanceof XIncludeFatalException) {
                throw (XIncludeFatalException)e.getCause();
            }
            throw new XIncludeFatalException(e.getMessage());
        }
        finally {
            if (this.isInjectingXInclude()) {
                this.endingInjectXInclude();
            }
        }
    }

    private SAXSource buildingXIncludeSource(XIncludeAttributes xIncludeAttributes) throws XIncludeFatalException, XIncludeResourceException {
        SAXSource source;
        if (xIncludeAttributes.isHrefPresent()) {
            XMLReader xmlReader;
            URI sourceURI = this.context.getSourceURI();
            XIncludeContext newContext = XIncludeContext.newContext(this.context);
            URI hrefUri = xIncludeAttributes.getHref();
            if (xIncludeAttributes.isBasePresent()) {
                newContext.setHrefURI(xIncludeAttributes.getBase().resolve(hrefUri));
            } else {
                newContext.setHrefURI(hrefUri);
            }
            newContext.setInitialBaseURI(sourceURI);
            XMLFilter filter = XIncProcEngine.newXIncludeFilter(newContext);
            try {
                xmlReader = XMLReaderFactory.createXMLReader();
                xmlReader.setProperty(LEXICALID, filter);
                xmlReader.setProperty(DECLID, filter);
                xmlReader.setFeature("http://xml.org/sax/features/resolve-dtd-uris", false);
                xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (SAXException e) {
                throw new XIncludeFatalException(e.getMessage());
            }
            filter.setParent(xmlReader);
            InputStream inputStream = this.readInputStream(sourceURI);
            InputStreamReader characterStream = new InputStreamReader(inputStream);
            InputSource inputSource = new InputSource(characterStream);
            source = new SAXSource(filter, inputSource);
            if (!xIncludeAttributes.isXPointerPresent()) {
                source.setSystemId(sourceURI.toASCIIString());
            }
        } else {
            InputStream inputStream = this.readInputStream(this.context.getInitialBaseURI());
            InputStreamReader characterStream = new InputStreamReader(inputStream);
            InputSource inputSource = new InputSource(characterStream);
            source = new SAXSource(inputSource);
        }
        return source;
    }

    private InputStream readInputStream(URI uri) throws XIncludeResourceException {
        try {
            String scheme = uri.getScheme();
            if (scheme == null || "file".equals(scheme)) {
                return new FileInputStream(uri.getPath());
            }
            return uri.toURL().openStream();
        }
        catch (FileNotFoundException e) {
            throw new XIncludeResourceException(e.getMessage());
        }
        catch (MalformedURLException e) {
            throw new XIncludeResourceException(e.getMessage());
        }
        catch (IOException e) {
            throw new XIncludeResourceException(e.getMessage());
        }
    }

    private void settingLanguage() {
        if (this.currentLangStack.empty()) {
            this.context.setLanguage(null);
        } else {
            this.context.setLanguage(this.currentLangStack.peek());
        }
    }

    private void injectingXInclude(XIncludeAttributes xIncludeAttributes, SAXSource source, XdmNode node) throws XIncludeFatalException, XPointerException {
        SAXDestination saxDestination = new SAXDestination((ContentHandler)this);
        if (xIncludeAttributes.isXPointerPresent()) {
            XIncProcXIncludeFilter filter;
            if (source.getXMLReader() instanceof XIncProcXIncludeFilter && (filter = (XIncProcXIncludeFilter)source.getXMLReader()).isHasUnparserEntity()) {
                throw new XIncludeFatalException("Resolve an xpointer scheme on a document that contains unexpanded entity reference information items");
            }
            XPointerEngine xPointerEngine = this.context.getConfiguration().newXPointerEngine();
            xPointerEngine.setLanguage(this.context.getLanguage());
            if (this.context.getConfiguration().isBaseUrisFixup() && null != this.context.getHrefURI() && xIncludeAttributes.isHrefPresent()) {
                xPointerEngine.setBaseURI(this.context.getHrefURI().toASCIIString());
            }
            LOG.trace("includeXmlContent start injecting xpointer");
            int includeLevel = this.elementLevel;
            int nbElements = xPointerEngine.executeToDestination(xIncludeAttributes.getXPointer(), node.asSource(), (Destination)saxDestination);
            if (1 == includeLevel && 1 != nbElements) {
                throw new XIncludeFatalException("Attempt to replace top level include with something other than one element.");
            }
            LOG.trace("includeXmlContent end injecting xpointer");
        } else {
            LOG.trace("includeXmlContent start injecting");
            try {
                this.context.getConfiguration().getProcessor().writeXdmValue((XdmValue)node, (Destination)saxDestination);
            }
            catch (SaxonApiException e) {
                throw new XIncludeFatalException(e.getMessage());
            }
            LOG.trace("includeXmlContent end injecting");
        }
    }

    private void includeTextContent(XIncludeAttributes xIncludeAttributes) throws XIncludeFatalException, XIncludeResourceException {
        String content = XIncProcUtils.readTextURI(this.context.getSourceURI(), xIncludeAttributes.getEncoding(), xIncludeAttributes.getAccept(), xIncludeAttributes.getAcceptLanguage());
        try {
            super.characters(content.toCharArray(), 0, content.length());
        }
        catch (SAXException e) {
            throw new XIncludeFatalException(e);
        }
    }

    private void startCommonElement(String uri, String localName, String qName, AttributesImpl attributesImpl) throws XIncludeFatalException {
        int langAttIdx = attributesImpl.getIndex("http://www.w3.org/XML/1998/namespace", XIncludeConstants.XMLLANG_QNAME.getLocalPart());
        if (this.isTopElement() && !this.isInXIncludeElement()) {
            if (this.context.isBaseFixup() && null != this.context.getHrefURI() && null == this.context.getCurrentBaseURI()) {
                URI newBaseURI = this.context.getHrefURI();
                attributesImpl.addAttribute("http://www.w3.org/XML/1998/namespace", XIncludeConstants.XMLBASE_QNAME.getLocalPart(), "xml:base", "CDATA", newBaseURI.toASCIIString());
            }
            if (!this.context.isLanguageFixup() && 0 <= langAttIdx) {
                attributesImpl.removeAttribute(langAttIdx);
            }
        }
        if (0 <= langAttIdx) {
            this.currentLangStack.push(attributesImpl.getValue(langAttIdx));
        } else {
            this.currentLangStack.push(null);
        }
        try {
            super.startElement(uri, localName, qName, attributesImpl);
        }
        catch (SAXException e) {
            throw new XIncludeFatalException(e);
        }
    }

    private void startFallbackElement() throws XIncludeFatalException {
        this.startingFallbackElement();
        if (!this.isInXIncludeElement() || this.isNeedFallback() && this.fallbackLevel > this.xIncludeLevel) {
            throw new XIncludeFatalException("Fallback not in xinclude element container");
        }
        if (this.alreadyProceedFallback) {
            throw new XIncludeFatalException("Only one fallback element allowed in xinclude");
        }
    }

    private void startXIncludeElement(Attributes atts) throws XIncludeFatalException, XIncludeResourceException {
        if (this.isInXIncludeElement() && !this.isInFallbackElement() && !this.isInjectingXInclude()) {
            throw new XIncludeFatalException("XInclude element is not allowed into xinclude");
        }
        XIncludeAttributes xIncludeAttributes = new XIncludeAttributes(atts);
        this.startingXIncludeElement();
        URI hrefUri = xIncludeAttributes.getHref();
        if (xIncludeAttributes.isBasePresent()) {
            this.context.setHrefURI(xIncludeAttributes.getBase().resolve(hrefUri));
        } else {
            this.context.setHrefURI(hrefUri);
        }
        URI sourceURI = XIncProcUtils.resolveBase(this.context.getInitialBaseURI(), this.context.getBaseURIPaths());
        if (xIncludeAttributes.isHrefPresent()) {
            sourceURI = sourceURI.resolve(xIncludeAttributes.getHref());
        }
        this.context.setSourceURI(sourceURI);
        if (xIncludeAttributes.isHrefPresent()) {
            this.context.addInInclusionChain(this.context.getSourceURI(), xIncludeAttributes.getXPointer());
        } else {
            this.context.addInInclusionChain(this.context.getInitialBaseURI(), xIncludeAttributes.getXPointer());
        }
        try {
            if (xIncludeAttributes.isXmlParse()) {
                this.includeXmlContent(xIncludeAttributes);
            } else {
                this.includeTextContent(xIncludeAttributes);
            }
        }
        catch (XIncludeResourceException e) {
            this.startingNeedFallback();
            this.context.setCurrentException(e);
        }
    }

    private QName calculateElementName(String uri, String localName, String qName) {
        QName elementQName = Strings.isNullOrEmpty((String)uri) && Strings.isNullOrEmpty((String)localName) && !Strings.isNullOrEmpty((String)qName) ? QName.valueOf(StringUtils.substringAfter((String)qName, (String)":")) : new QName(uri, localName);
        return elementQName;
    }

    private boolean isInFallbackElement() {
        return 0 < this.fallbackLevel;
    }

    private void startingElement() {
        ++this.elementLevel;
    }

    private void endingElement() {
        --this.elementLevel;
    }

    private boolean isTopElement() {
        return 1 == this.elementLevel;
    }

    private void startingFallbackElement() {
        ++this.fallbackLevel;
    }

    private void endingFallbackElement() {
        --this.fallbackLevel;
        this.alreadyProceedFallback = true;
    }

    private boolean isInXIncludeElement() {
        return 0 < this.xIncludeLevel;
    }

    private void startingXIncludeElement() {
        ++this.xIncludeLevel;
    }

    private void endingXIncludeElement() {
        --this.xIncludeLevel;
        this.alreadyProceedFallback = false;
    }

    private boolean isInjectingXInclude() {
        return 0 < this.injectingXIncludeLevel;
    }

    private void startingInjectXInclude() {
        ++this.injectingXIncludeLevel;
    }

    private void endingInjectXInclude() {
        --this.injectingXIncludeLevel;
    }

    private void startingNeedFallback() {
        ++this.needFallbackLevel;
    }

    private void endingNeedFallback() {
        --this.needFallbackLevel;
    }

    private boolean isNeedFallback() {
        return 0 < this.xIncludeLevel && this.needFallbackLevel == this.xIncludeLevel;
    }

    private boolean isUsable() {
        return this.isNeedFallback() && this.isInFallbackElement() || !this.isInFallbackElement() && !this.isInXIncludeElement() || this.isInXIncludeElement() && this.isInjectingXInclude();
    }
}

