/*
 * Decompiled with CFR 0.152.
 */
package org.etourdot.xincproc;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.etourdot.xincproc.xinclude.XIncProcEngine;
import org.etourdot.xincproc.xinclude.exceptions.XIncludeFatalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XIncProcCLI {
    private static final Logger LOG = LoggerFactory.getLogger(XIncProcCLI.class);
    private final Options options = new Options();

    private XIncProcCLI() {
        this.options.addOption("h", false, "Help");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withDescription((String)"input file");
        Option input = OptionBuilder.create((String)"if");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withDescription((String)"output file");
        Option output = OptionBuilder.create((String)"of");
        this.options.addOption(input).addOption(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(String[] args, InputStream stdin, PrintStream stdout, PrintStream stderr) throws IOException {
        OutputStream outputStream;
        GnuParser parser = new GnuParser();
        CommandLine commandLine = parser.parse(this.options, args);
        if (!commandLine.hasOption("if")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("XIncProc", this.options);
            return -1;
        }
        File inputFile = new File(commandLine.getOptionValue("if"));
        FileInputStream fis = new FileInputStream(inputFile);
        if (commandLine.hasOption("of")) {
            File outputFile = new File(commandLine.getOptionValue("of"));
            outputStream = new FileOutputStream(outputFile);
        } else {
            outputStream = stdout;
        }
        try {
            XIncProcEngine.parse((InputStream)fis, (String)inputFile.toURI().toASCIIString(), (OutputStream)outputStream);
        }
        catch (XIncludeFatalException e) {
            int n;
            try {
                System.err.println("XInclude Fatal error: " + e.getMessage());
                n = -1;
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close((Closeable)fis, (boolean)true);
                    Closeables.close((Closeable)outputStream, (boolean)true);
                    throw throwable;
                }
                catch (ParseException ignored) {
                    this.help(stderr);
                    return 1;
                }
            }
            Closeables.close((Closeable)fis, (boolean)true);
            Closeables.close((Closeable)outputStream, (boolean)true);
            return n;
        }
        Closeables.close((Closeable)fis, (boolean)true);
        Closeables.close((Closeable)outputStream, (boolean)true);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void help(PrintStream destination) {
        HelpFormatter helpFormatter = new HelpFormatter();
        PrintWriter printWriter = new PrintWriter(destination);
        try {
            helpFormatter.printHelp(printWriter, helpFormatter.getWidth(), "java -jar xincproc.jar", null, this.options, helpFormatter.getLeftPadding(), helpFormatter.getDescPadding(), null, true);
        }
        finally {
            printWriter.flush();
            printWriter.close();
        }
    }

    public static void main(String ... args) throws IOException {
        System.exit(new XIncProcCLI().execute(args, System.in, System.out, System.err));
    }
}

