/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.Serializable;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.StagingSpec;
import org.protempa.proposition.value.GranularityFactory;
import org.protempa.proposition.value.UnitFactory;

public final class RelationalDatabaseSpec
implements Serializable {
    private static final long serialVersionUID = -7404642542962229266L;
    private static final EntitySpec[] EMPTY_ES_ARR = new EntitySpec[0];
    private static final StagingSpec[] EMPTY_SS_ARR = new StagingSpec[0];
    private EntitySpec[] primitiveParameterSpecs = EMPTY_ES_ARR;
    private EntitySpec[] eventSpecs = EMPTY_ES_ARR;
    private EntitySpec[] constantSpecs = EMPTY_ES_ARR;
    private StagingSpec[] stagedSpecs = EMPTY_SS_ARR;
    private final UnitFactory units;
    private final GranularityFactory granularities;

    RelationalDatabaseSpec(EntitySpec[] primitiveParameterSpecs, EntitySpec[] eventSpecs, EntitySpec[] constantSpecs, StagingSpec[] stagedSpecs, UnitFactory units, GranularityFactory granularities) {
        this.setPrimitiveParameterSpecs(primitiveParameterSpecs);
        this.setConstantSpecs(constantSpecs);
        this.setEventSpecs(eventSpecs);
        this.setStagedSpecs(stagedSpecs);
        this.units = units;
        this.granularities = granularities;
    }

    GranularityFactory getGranularities() {
        return this.granularities;
    }

    UnitFactory getUnits() {
        return this.units;
    }

    EntitySpec[] getConstantSpecs() {
        return (EntitySpec[])this.constantSpecs.clone();
    }

    private void setConstantSpecs(EntitySpec[] constantParameterSpecs) {
        this.constantSpecs = constantParameterSpecs == null ? EMPTY_ES_ARR : (EntitySpec[])constantParameterSpecs.clone();
    }

    EntitySpec[] getEventSpecs() {
        return (EntitySpec[])this.eventSpecs.clone();
    }

    private void setEventSpecs(EntitySpec[] eventSpecs) {
        this.eventSpecs = eventSpecs == null ? EMPTY_ES_ARR : (EntitySpec[])eventSpecs.clone();
    }

    EntitySpec[] getPrimitiveParameterSpecs() {
        return (EntitySpec[])this.primitiveParameterSpecs.clone();
    }

    private void setPrimitiveParameterSpecs(EntitySpec[] primitiveParameterSpecs) {
        this.primitiveParameterSpecs = primitiveParameterSpecs == null ? EMPTY_ES_ARR : (EntitySpec[])primitiveParameterSpecs.clone();
    }

    StagingSpec[] getStagedSpecs() {
        return (StagingSpec[])this.stagedSpecs.clone();
    }

    private void setStagedSpecs(StagingSpec[] stagedSpecs) {
        this.stagedSpecs = stagedSpecs == null ? EMPTY_SS_ARR : (StagingSpec[])stagedSpecs.clone();
    }
}

