/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import org.arp.javautil.string.StringUtil;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;

public final class TableSpec {
    private final ColumnSpec spec;

    private TableSpec(String schema, String table) {
        this.spec = new ColumnSpec(schema, table);
    }

    private TableSpec(ColumnSpec spec) {
        this.spec = spec;
    }

    public static TableSpec withSchemaAndTable(String schema, String table) {
        return new TableSpec(schema, table);
    }

    public String getSchema() {
        return this.spec.getSchema();
    }

    public String getTable() {
        return this.spec.getTable();
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof TableSpec) {
            TableSpec other = (TableSpec)o;
            return StringUtil.equals((String)other.getSchema(), (String)this.getSchema()) && other.getTable().equals(this.getTable());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this.spec.getSchema() != null) {
            result = 31 * result + this.spec.getSchema().hashCode();
        }
        result = 31 * result + this.spec.getTable().hashCode();
        return result;
    }

    public String toString() {
        String schema = this.spec.getSchema();
        return (schema != null ? schema + "." : "") + this.spec.getTable();
    }
}

