/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.util.Map;
import org.protempa.backend.dsb.relationaldb.CaseClause;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.ColumnSpecInfo;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.SelectClause;
import org.protempa.backend.dsb.relationaldb.TableAliaser;
import org.protempa.backend.dsb.relationaldb.mappings.Mappings;

public abstract class AbstractSelectClause
implements SelectClause {
    private final ColumnSpecInfo info;
    private final TableAliaser referenceIndices;
    private final EntitySpec entitySpec;
    private CaseClause caseClause;
    private final boolean wrapKeyId;

    protected AbstractSelectClause(ColumnSpecInfo info, TableAliaser referenceIndices, EntitySpec entitySpec, boolean wrapKeyId) {
        this.info = info;
        this.referenceIndices = referenceIndices;
        this.entitySpec = entitySpec;
        this.caseClause = null;
        this.wrapKeyId = wrapKeyId;
    }

    protected TableAliaser getReferenceIndices() {
        return this.referenceIndices;
    }

    @Override
    public String generateClause() {
        int[] uniqueIdIndices;
        StringBuilder selectClause = new StringBuilder("SELECT ");
        int i = 0;
        if (this.info.getFinishTimeIndex() > 0) {
            ++i;
        }
        if (this.info.getPropertyIndices() != null) {
            i += this.info.getPropertyIndices().size();
        }
        if (this.info.getCodeIndex() > 0) {
            ++i;
        }
        if (this.info.getStartTimeIndex() > 0) {
            ++i;
        }
        if ((uniqueIdIndices = this.info.getUniqueIdIndices()) != null) {
            i += uniqueIdIndices.length;
        }
        if (this.info.isUsingKeyIdIndex()) {
            ++i;
        }
        if (this.info.getValueIndex() > 0) {
            ++i;
        }
        if (this.info.getReferenceIndices() != null) {
            i += this.info.getReferenceIndices().size();
        }
        int[] indices = new int[i];
        String[] names = new String[i];
        int k = 0;
        indices[k] = 0;
        if (this.info.isUsingKeyIdIndex()) {
            names[k++] = "keyid";
        }
        if (uniqueIdIndices != null) {
            for (int m = 0; m < uniqueIdIndices.length; ++m) {
                indices[k] = uniqueIdIndices[m];
                names[k++] = "uniqueid" + m;
            }
        }
        if (this.info.getCodeIndex() > 0) {
            indices[k] = this.info.getCodeIndex();
            names[k++] = "code";
        }
        if (this.info.getStartTimeIndex() > 0) {
            indices[k] = this.info.getStartTimeIndex();
            names[k++] = "starttime";
        }
        if (this.info.getFinishTimeIndex() > 0) {
            indices[k] = this.info.getFinishTimeIndex();
            names[k++] = "finishtime";
        }
        if (this.info.getValueIndex() > 0) {
            indices[k] = this.info.getValueIndex();
            names[k++] = "value";
        }
        if (this.info.getPropertyIndices() != null) {
            PropertySpec[] propertySpecs;
            for (PropertySpec propertySpec : propertySpecs = this.entitySpec.getPropertySpecs()) {
                int propertyIndex;
                String propertyName = propertySpec.getName();
                indices[k] = propertyIndex = this.info.getPropertyIndices().get(propertyName).intValue();
                names[k++] = propertyName + "_value";
            }
        }
        if (this.info.getReferenceIndices() != null) {
            for (Map.Entry<String, Integer> entry : this.info.getReferenceIndices().entrySet()) {
                indices[k] = entry.getValue();
                names[k++] = entry.getKey() + "_ref";
            }
        }
        boolean unique = this.info.isUnique();
        for (int j = 0; j < indices.length; ++j) {
            boolean hasNext;
            ColumnSpec cs = this.info.getColumnSpecs().get(indices[j]).getColumnSpec();
            String name = names[j];
            boolean distinctRequested = j == 0 && !unique;
            boolean bl = hasNext = j < indices.length - 1;
            if (name == null) {
                throw new AssertionError((Object)"name cannot be null");
            }
            selectClause.append((CharSequence)this.generateColumn(distinctRequested, cs, name, hasNext));
        }
        if (this.caseClause != null) {
            selectClause.append(this.caseClause.generateClause());
        }
        return selectClause.toString();
    }

    protected abstract String wrapKeyIdInConversion(String var1);

    StringBuilder generateColumn(boolean distinctRequested, ColumnSpec columnSpec, String name, boolean hasNext) {
        StringBuilder result = new StringBuilder();
        if (distinctRequested) {
            result.append("DISTINCT ");
        }
        if (name.equals("keyid") && this.wrapKeyId) {
            result.append(this.wrapKeyIdInConversion(this.referenceIndices.generateColumnReference(columnSpec))).append(" AS ").append(name);
        } else {
            result.append(this.referenceIndices.generateColumnReference(columnSpec)).append(" AS ").append(name);
        }
        if (hasNext) {
            result.append(", ");
        }
        return result;
    }

    protected abstract CaseClause getCaseClause(Object[] var1, ColumnSpec var2, Mappings var3);

    private void setCaseClause(CaseClause caseClause) {
        this.caseClause = caseClause;
    }

    @Override
    public void setCaseClause(Object[] sqlCodes, ColumnSpec columnSpec, Mappings mappings) {
        this.setCaseClause(this.getCaseClause(sqlCodes, columnSpec, mappings));
    }
}

