/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.log.Logging;
import org.protempa.backend.dsb.relationaldb.AbstractResultProcessor;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.QueryResultsCacheException;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.ResultCache;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;

abstract class RefResultProcessor<P extends Proposition>
extends AbstractResultProcessor {
    private static final int FLUSH_SIZE = 2000000;
    private ReferenceSpec referenceSpec;
    private ResultCache<P> cache;

    protected RefResultProcessor(ResultCache<P> results, ReferenceSpec referenceSpec, EntitySpec entitySpec, String dataSourceBackendId) {
        super(entitySpec, dataSourceBackendId);
        assert (results != null) : "results cannot be null";
        assert (referenceSpec != null) : "referenceSpec cannot be null";
        this.cache = results;
        this.referenceSpec = referenceSpec;
    }

    public final void process(ResultSet resultSet) throws SQLException {
        EntitySpec entitySpec = this.getEntitySpec();
        int count = 0;
        Object[] uniqueIds = new String[entitySpec.getUniqueIdSpecs().length];
        Object[] refUniqueIds = new String[this.referenceSpec.getUniqueIdSpecs().length];
        UniqueId uniqueIdentifier = null;
        Object[] uniqueIdsCopy = new String[uniqueIds.length];
        String entitySpecName = entitySpec.getName();
        String refSpecEntityName = this.referenceSpec.getEntityName();
        Logger logger = SQLGenUtil.logger();
        while (resultSet.next()) {
            int i = 1;
            i = RefResultProcessor.readUniqueIds((String[])uniqueIds, resultSet, i);
            if (org.arp.javautil.arrays.Arrays.contains((Object[])uniqueIds, null)) continue;
            if (uniqueIdentifier == null || !Arrays.equals(uniqueIds, uniqueIdsCopy)) {
                uniqueIdentifier = this.generateUniqueId(entitySpecName, (String[])uniqueIds);
                System.arraycopy(uniqueIds, 0, uniqueIdsCopy, 0, uniqueIds.length);
            }
            i = RefResultProcessor.readUniqueIds((String[])refUniqueIds, resultSet, i);
            if (org.arp.javautil.arrays.Arrays.contains((Object[])refUniqueIds, null)) continue;
            UniqueId refUniqueIdentifier = this.generateUniqueId(refSpecEntityName, (String[])refUniqueIds);
            this.cache.addReference(uniqueIdentifier, refUniqueIdentifier);
            if (++count % 2000000 != 0) continue;
            try {
                this.cache.flushReferences(this);
            }
            catch (IOException ex) {
                throw new QueryResultsCacheException("Flushing references to cache failed", ex);
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            Logging.logCount((Logger)logger, (Level)Level.FINE, (int)count, (String)"Retrieved {0} reference", (String)"Retrieved {0} references");
        }
        try {
            this.cache.flushReferences(this);
        }
        catch (IOException ex) {
            throw new QueryResultsCacheException("Flushing references to cache failed", ex);
        }
        if (logger.isLoggable(Level.FINE)) {
            Logging.logCount((Logger)logger, (Level)Level.FINE, (int)count, (String)"Retrieved {0} reference total", (String)"Retrieved {0} references total");
        }
    }

    abstract void addReferences(P var1, List<UniqueId> var2);

    final ReferenceSpec getReferenceSpec() {
        return this.referenceSpec;
    }

    final void setReferenceSpec(ReferenceSpec referenceSpec) {
        assert (referenceSpec != null) : "referenceSpec cannot be null";
        this.referenceSpec = referenceSpec;
    }
}

