/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataSourceInitialContextBinder
implements AutoCloseable {
    private final InitialContext initialContext;
    private final Map<DataSource, String> dataSourceBindings = new HashMap<DataSource, String>();

    public DataSourceInitialContextBinder() throws NamingException {
        this.initialContext = new InitialContext();
        this.initialContext.createSubcontext("java:");
        this.initialContext.createSubcontext("java:/comp");
        this.initialContext.createSubcontext("java:/comp/env");
        this.initialContext.createSubcontext("java:/comp/env/jdbc");
    }

    public void bind(String name, DataSource dataSource) throws NamingException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource cannot be null");
        }
        String jndiUrl = "java:/comp/env/jdbc/" + name;
        this.initialContext.bind(jndiUrl, (Object)dataSource);
        this.dataSourceBindings.put(dataSource, jndiUrl);
    }

    public void unbind(DataSource dataSource) throws NamingException {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource cannot be null");
        }
        String jndiUrl = this.dataSourceBindings.get(dataSource);
        if (jndiUrl == null) {
            throw new NamingException("No such binding");
        }
        this.initialContext.unbind(jndiUrl);
        this.dataSourceBindings.remove(dataSource);
    }

    public void unbindAll() throws NamingException {
        for (DataSource dataSource : new ArrayList<DataSource>(this.dataSourceBindings.keySet())) {
            this.unbind(dataSource);
        }
    }

    @Override
    public void close() throws Exception {
        this.unbindAll();
        this.initialContext.destroySubcontext("java:/comp/env/jdbc");
        this.initialContext.destroySubcontext("java:/comp/env");
        this.initialContext.destroySubcontext("java:/comp");
        this.initialContext.destroySubcontext("java:");
        this.initialContext.close();
    }

    static {
        System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
    }
}

