/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.IntColumnSpecWrapper;
import org.protempa.backend.dsb.relationaldb.JoinSpec;

public final class TableAliaser {
    private static final String DEFAULT_PREFIX = "a";
    private final String prefix;
    private Map<ColumnSpec, Integer> indices;

    public TableAliaser(List<IntColumnSpecWrapper> columnSpecs) {
        this(columnSpecs, DEFAULT_PREFIX);
    }

    public TableAliaser(List<IntColumnSpecWrapper> columnSpecs, String prefix) {
        this.prefix = prefix;
        assert (!columnSpecs.isEmpty()) : "columnSpecs cannot be empty";
        this.computeReferenceIndices(columnSpecs);
    }

    int getIndex(ColumnSpec columnSpec) {
        if (this.indices.containsKey(columnSpec)) {
            return this.indices.get(columnSpec);
        }
        return -1;
    }

    public String generateTableReference(ColumnSpec columnSpec) {
        return this.prefix + this.getIndex(columnSpec);
    }

    public String generateColumnReference(ColumnSpec columnSpec) {
        String expr = columnSpec.getExpr();
        if (expr == null) {
            expr = this.generateTableReference(columnSpec) + "." + columnSpec.getColumn();
        }
        return expr;
    }

    String generateColumnReferenceWithOp(ColumnSpec columnSpec) {
        StringBuilder result = new StringBuilder();
        result.append(this.generateColumnReference(columnSpec));
        if (columnSpec.getColumnOp() != null) {
            switch (columnSpec.getColumnOp()) {
                case UPPER: {
                    result.append("UPPER");
                    break;
                }
                default: {
                    throw new AssertionError((Object)("invalid column op: " + (Object)((Object)columnSpec.getColumnOp())));
                }
            }
            result.insert(0, '(');
            result.append(')');
        }
        return result.toString();
    }

    private void computeReferenceIndices(List<IntColumnSpecWrapper> columnSpecs) {
        LinkedHashMap<ColumnSpec, Integer> tempIndices = new LinkedHashMap<ColumnSpec, Integer>();
        int index = 1;
        JoinSpec currentJoin = null;
        List<ColumnSpec> baseSpecs = columnSpecs.get(0).getColumnSpec().asList();
        boolean first = true;
        for (IntColumnSpecWrapper columnSpec : columnSpecs) {
            if (columnSpec.getColumnSpec().getExpr() == null) {
                if (currentJoin == null && !first) {
                    ColumnSpec cs = columnSpec.getIsSameAs();
                    if (cs == null) {
                        for (ColumnSpec bs : baseSpecs) {
                            if (!bs.isSameSchemaAndTable(columnSpec.getColumnSpec())) continue;
                            cs = bs;
                            break;
                        }
                    }
                    if (cs != null) {
                        Integer previousInstanceIndex = (Integer)tempIndices.get(cs);
                        tempIndices.put(columnSpec.getColumnSpec(), previousInstanceIndex);
                    }
                } else {
                    tempIndices.put(columnSpec.getColumnSpec(), index++);
                    first = false;
                }
            }
            currentJoin = columnSpec.getJoin();
        }
        this.indices = tempIndices;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

