/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Collections;
import java.util.Set;
import org.protempa.AbstractSource;
import org.protempa.Algorithm;
import org.protempa.AlgorithmSource;
import org.protempa.AlgorithmSourceReadException;
import org.protempa.AlgorithmSourceUpdatedEvent;
import org.protempa.Algorithms;
import org.protempa.SourceCloseException;
import org.protempa.backend.AlgorithmSourceBackendUpdatedEvent;
import org.protempa.backend.Backend;
import org.protempa.backend.asb.AlgorithmSourceBackend;

public final class AlgorithmSourceImpl
extends AbstractSource<AlgorithmSourceUpdatedEvent, AlgorithmSourceBackend, AlgorithmSourceUpdatedEvent, AlgorithmSourceBackendUpdatedEvent>
implements AlgorithmSource {
    private final Algorithms algorithms = new Algorithms();
    private boolean readAlgorithmsCalled;

    public AlgorithmSourceImpl(AlgorithmSourceBackend[] backends) {
        super((Backend[])(backends != null ? backends : new AlgorithmSourceBackend[]{}));
    }

    private void initializeIfNeeded() throws AlgorithmSourceReadException {
        if (this.isClosed()) {
            throw new AlgorithmSourceReadException("Algorithm source already closed!");
        }
    }

    @Override
    public Algorithm readAlgorithm(String id) throws AlgorithmSourceReadException {
        Algorithm result = null;
        if (id != null) {
            if (this.algorithms != null) {
                result = this.algorithms.getAlgorithm(id);
            }
            if (result == null) {
                AlgorithmSourceBackend backend;
                this.initializeIfNeeded();
                AlgorithmSourceBackend[] algorithmSourceBackendArray = (AlgorithmSourceBackend[])this.getBackends();
                int n = algorithmSourceBackendArray.length;
                for (int i = 0; i < n && (result = (backend = algorithmSourceBackendArray[i]).readAlgorithm(id, this.algorithms)) == null; ++i) {
                }
            }
        }
        return result;
    }

    @Override
    public Set<Algorithm> readAlgorithms() throws AlgorithmSourceReadException {
        this.initializeIfNeeded();
        if (this.algorithms != null) {
            if (!this.readAlgorithmsCalled && this.getBackends() != null) {
                for (AlgorithmSourceBackend backend : (AlgorithmSourceBackend[])this.getBackends()) {
                    backend.readAlgorithms(this.algorithms);
                }
                this.readAlgorithmsCalled = true;
            }
            return this.algorithms.getAlgorithms();
        }
        return Collections.emptySet();
    }

    @Override
    public void close() throws SourceCloseException {
        this.clear();
        super.close();
    }

    @Override
    public void clear() {
        if (this.algorithms != null) {
            this.algorithms.closeAndClear();
        }
        this.readAlgorithmsCalled = false;
    }

    @Override
    public void backendUpdated(AlgorithmSourceBackendUpdatedEvent event) {
        this.fireAlgorithmSourceUpdated();
    }

    private void fireAlgorithmSourceUpdated() {
        this.fireSourceUpdated(new AlgorithmSourceUpdatedEvent(this));
    }
}

