/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EqualToWhereConstraintProcessor;
import org.protempa.backend.dsb.relationaldb.InequalityWhereConstraintProcessor;
import org.protempa.backend.dsb.relationaldb.LikeWhereConstraintProcessor;
import org.protempa.backend.dsb.relationaldb.NotEqualToWhereConstraintProcessor;
import org.protempa.backend.dsb.relationaldb.Operator;
import org.protempa.backend.dsb.relationaldb.TableAliaser;
import org.protempa.backend.dsb.relationaldb.WhereClause;

abstract class WhereConstraintProcessor {
    private final ColumnSpec columnSpec;
    private final Operator constraint;
    private final WhereClause whereClause;
    private final Object[] sqlCodes;
    private final TableAliaser referenceIndices;

    protected WhereConstraintProcessor(ColumnSpec columnSpec, Operator constraint, WhereClause whereClause, Object[] sqlCodes, TableAliaser referenceIndices) {
        this.columnSpec = columnSpec;
        this.constraint = constraint;
        this.whereClause = whereClause;
        this.sqlCodes = sqlCodes;
        this.referenceIndices = referenceIndices;
    }

    static WhereConstraintProcessor getInstance(ColumnSpec columnSpec, Operator constraint, WhereClause whereClause, Object[] sqlCodes, TableAliaser referenceIndices) {
        switch (constraint) {
            case EQUAL_TO: {
                return new EqualToWhereConstraintProcessor(columnSpec, constraint, whereClause, sqlCodes, referenceIndices);
            }
            case NOT_EQUAL_TO: {
                return new NotEqualToWhereConstraintProcessor(columnSpec, constraint, whereClause, sqlCodes, referenceIndices);
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL_TO: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL_TO: {
                return new InequalityWhereConstraintProcessor(columnSpec, constraint, whereClause, sqlCodes, referenceIndices);
            }
            case LIKE: {
                return new LikeWhereConstraintProcessor(columnSpec, constraint, whereClause, sqlCodes, referenceIndices);
            }
        }
        throw new AssertionError((Object)("Invalid constraint: " + (Object)((Object)constraint)));
    }

    protected ColumnSpec getColumnSpec() {
        return this.columnSpec;
    }

    protected Operator getConstraint() {
        return this.constraint;
    }

    protected WhereClause getWhereClause() {
        return this.whereClause;
    }

    protected Object[] getSqlCodes() {
        return this.sqlCodes;
    }

    protected TableAliaser getReferenceIndices() {
        return this.referenceIndices;
    }

    protected abstract String processConstraint();
}

