/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.mvel.ConversionException;
import org.protempa.dest.table.PropositionValueColumnSpec;

class AggregationTypeValueConverter
implements SingleValueConverter {
    private static final DualHashBidiMap<PropositionValueColumnSpec.Type, String> aggregationTypeToStringMap = new DualHashBidiMap();

    AggregationTypeValueConverter() {
    }

    public boolean canConvert(Class type) {
        return PropositionValueColumnSpec.Type.class.isAssignableFrom(type);
    }

    public String toString(Object obj) {
        String unitString = (String)aggregationTypeToStringMap.get(obj);
        if (unitString == null) {
            String msg = "Unable to convert unexpected Type object to an aggregationType attribute value: " + obj.toString();
            throw new ConversionException(msg);
        }
        return unitString;
    }

    public Object fromString(String str) {
        PropositionValueColumnSpec.Type type = (PropositionValueColumnSpec.Type)((Object)aggregationTypeToStringMap.getKey((Object)str));
        if (type == null) {
            String msg = "Unknown aggregation type value string: " + str;
            throw new ConversionException(msg);
        }
        return type;
    }

    static {
        aggregationTypeToStringMap.put((Object)PropositionValueColumnSpec.Type.MAX, (Object)"max");
        aggregationTypeToStringMap.put((Object)PropositionValueColumnSpec.Type.MIN, (Object)"min");
        aggregationTypeToStringMap.put((Object)PropositionValueColumnSpec.Type.FIRST, (Object)"first");
        aggregationTypeToStringMap.put((Object)PropositionValueColumnSpec.Type.LAST, (Object)"last");
        aggregationTypeToStringMap.put((Object)PropositionValueColumnSpec.Type.SUM, (Object)"sum");
    }
}

