/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.Connection;
import java.sql.SQLException;
import org.arp.javautil.sql.DatabaseMetaDataWrapper;
import org.arp.javautil.sql.DatabaseVersion;
import org.arp.javautil.sql.DriverVersion;
import org.protempa.backend.dsb.relationaldb.AbstractSQLGenerator;

public abstract class AbstractSQLGeneratorWithCompatChecks
extends AbstractSQLGenerator {
    private final String driverClassName;
    private final String driverName;
    private final DriverVersion minDriverVersion;
    private final DriverVersion maxDriverVersion;
    private final String databaseProductName;
    private final DatabaseVersion minDatabaseVersion;
    private final DatabaseVersion maxDatabaseVersion;

    public AbstractSQLGeneratorWithCompatChecks(String driverClassName, String driverName, DriverVersion minDriverVersion, DriverVersion maxDriverVersion, String databaseProductName, DatabaseVersion minDatabaseVersion, DatabaseVersion maxDatabaseVersion) {
        if (driverName == null) {
            throw new IllegalArgumentException("driverName cannot be null");
        }
        if (databaseProductName == null) {
            throw new IllegalArgumentException("databaseProductName cannot be null");
        }
        this.driverClassName = driverClassName;
        this.driverName = driverName;
        this.minDriverVersion = minDriverVersion;
        this.maxDriverVersion = maxDriverVersion;
        this.databaseProductName = databaseProductName;
        this.minDatabaseVersion = minDatabaseVersion;
        this.maxDatabaseVersion = maxDatabaseVersion;
    }

    @Override
    public final boolean checkCompatibility(Connection connection) throws SQLException {
        DatabaseMetaDataWrapper metaDataWrapper = new DatabaseMetaDataWrapper(connection.getMetaData());
        return metaDataWrapper.isDatabaseCompatible(this.databaseProductName, this.minDatabaseVersion, this.maxDatabaseVersion) && metaDataWrapper.isDriverCompatible(this.driverName, this.minDriverVersion, this.maxDriverVersion);
    }

    @Override
    protected final String getDriverClassNameToLoad() {
        return this.driverClassName;
    }
}

