/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.LocalUniqueId;

final class SQLGenLocalUniqueId
implements LocalUniqueId {
    private static final long serialVersionUID = 3956023315666447630L;
    private static final Object NEXT_NUMERICAL_ID_LOCK = new Object();
    private static int NEXT_NUMERICAL_ID = 0;
    private String entitySpecName;
    private String[] dbIds;
    private String id;
    private volatile int hashCode;
    private int numericalId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQLGenLocalUniqueId(String entitySpecName, String[] dbIds, int[] maxWidths) {
        assert (entitySpecName != null) : "entitySpecName cannot be null";
        assert (dbIds != null) : "dbIds cannot be null";
        assert (!ArrayUtils.contains((Object[])dbIds, null)) : "dbIds cannot contain a null element";
        this.entitySpecName = entitySpecName;
        this.dbIds = (String[])dbIds.clone();
        if (this.dbIds.length == 1) {
            try {
                this.numericalId = Integer.parseInt(this.dbIds[0]);
            }
            catch (NumberFormatException ex) {
                Object object = NEXT_NUMERICAL_ID_LOCK;
                synchronized (object) {
                    this.numericalId = NEXT_NUMERICAL_ID++;
                }
            }
        } else {
            if (maxWidths == null) {
                Object ex = NEXT_NUMERICAL_ID_LOCK;
                synchronized (ex) {
                    this.numericalId = NEXT_NUMERICAL_ID++;
                }
            }
            assert (dbIds.length == maxWidths.length) : "maxWidths, if not null, must have the same number of values as dbIds";
            StringBuilder db = new StringBuilder();
            try {
                for (int i = 0; i < this.dbIds.length; ++i) {
                    if (i == 0) {
                        db.append(this.dbIds[i]);
                        continue;
                    }
                    db.append(StringUtils.leftPad((String)this.dbIds[i], (int)maxWidths[i], (char)'0'));
                }
                this.numericalId = Integer.parseInt(db.toString());
            }
            catch (NumberFormatException ex) {
                Object object = NEXT_NUMERICAL_ID_LOCK;
                synchronized (object) {
                    this.numericalId = NEXT_NUMERICAL_ID++;
                }
            }
        }
    }

    String[] getDbIds() {
        return (String[])this.dbIds.clone();
    }

    public String getId() {
        if (this.id == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.entitySpecName);
            for (String dbId : this.dbIds) {
                builder.append('^');
                builder.append(dbId);
            }
            this.id = builder.toString();
        }
        return this.id;
    }

    public int getNumericalId() {
        return this.numericalId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLGenLocalUniqueId other = (SQLGenLocalUniqueId)obj;
        if (!this.entitySpecName.equals(other.entitySpecName)) {
            return false;
        }
        return Arrays.equals(this.dbIds, other.dbIds);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 3;
            hash = 53 * hash + this.entitySpecName.hashCode();
            this.hashCode = hash = 53 * hash + Arrays.hashCode(this.dbIds);
        }
        return this.hashCode;
    }

    public LocalUniqueId clone() {
        try {
            return (SQLGenLocalUniqueId)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)"Never reached!");
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.entitySpecName);
        s.writeInt(this.dbIds.length);
        for (String dbId : this.dbIds) {
            s.writeObject(dbId);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.entitySpecName = (String)s.readObject();
        if (this.entitySpecName == null) {
            throw new InvalidObjectException("name cannot be null. Can't restore");
        }
        this.entitySpecName = this.entitySpecName.intern();
        int dbIdsLen = s.readInt();
        if (dbIdsLen < 0) {
            throw new InvalidObjectException("dbIds length invalid (" + dbIdsLen + "). Can't restore");
        }
        this.dbIds = new String[dbIdsLen];
        for (int i = 0; i < dbIdsLen; ++i) {
            String dbId = (String)s.readObject();
            if (dbId == null) {
                throw new InvalidObjectException("dbIds cannot contain a null value. Can't restore");
            }
            this.dbIds[i] = dbId;
        }
    }
}

