/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import java.io.Serializable;
import org.drools.base.accumulators.AccumulateFunction;

public class AverageAccumulateFunction
implements AccumulateFunction {
    private static final long serialVersionUID = -7290793942538074637L;

    public Object createContext() {
        return new AverageData();
    }

    public void init(Object context) throws Exception {
        AverageData data = (AverageData)context;
        data.count = 0;
        data.total = 0.0;
    }

    public void accumulate(Object context, Object value) {
        AverageData data = (AverageData)context;
        ++data.count;
        data.total += ((Number)value).doubleValue();
    }

    public void reverse(Object context, Object value) throws Exception {
        AverageData data = (AverageData)context;
        --data.count;
        data.total -= ((Number)value).doubleValue();
    }

    public Object getResult(Object context) throws Exception {
        AverageData data = (AverageData)context;
        return new Double(data.count == 0 ? 0.0 : data.total / (double)data.count);
    }

    public boolean supportsReverse() {
        return true;
    }

    protected static class AverageData
    implements Serializable {
        private static final long serialVersionUID = -4919742651209619505L;
        public int count = 0;
        public double total = 0.0;

        protected AverageData() {
        }
    }
}

