/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuildException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.SubtreeBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;
import edu.emory.cci.aiw.i2b2etl.dest.table.ProviderDimension;
import java.util.TreeMap;

class ProviderConceptTreeBuilder
implements OntologyBuilder,
SubtreeBuilder {
    private final Metadata metadata;
    private Concept root;
    private TreeMap<Character, Concept> alpha;
    private final boolean skipProviderHierarchy;

    ProviderConceptTreeBuilder(Metadata metadata) {
        assert (metadata != null) : "metadata cannot be null";
        this.metadata = metadata;
        this.skipProviderHierarchy = this.metadata.getSettings().getSkipProviderHierarchy();
    }

    @Override
    public void build(Concept parent) throws OntologyBuildException {
        if (!this.skipProviderHierarchy) {
            try {
                this.root = this.metadata.getOrCreateHardCodedFolder("Provider");
                this.root.setFactTableColumn("provider_id");
                this.root.setTableName("provider_dimension");
                this.root.setColumnName("provider_path");
                if (parent != null) {
                    this.root.setAlreadyLoaded(parent.isAlreadyLoaded());
                    parent.add(this.root);
                }
                this.alpha = this.createAlphaCategoryConcepts();
            }
            catch (InvalidConceptCodeException ex) {
                throw new OntologyBuildException("Could not build provider concept tree", ex);
            }
        }
    }

    void add(ProviderDimension pd) throws InvalidConceptCodeException {
        if (!this.skipProviderHierarchy) {
            String fullName = pd.getConcept().getDisplayName();
            Concept parent = this.alpha.get(Character.valueOf(fullName.toUpperCase().charAt(0)));
            if (parent == null) {
                parent = this.metadata.getOrCreateHardCodedFolder("Provider", "Other");
                parent.setFactTableColumn("provider_id");
                parent.setTableName("provider_dimension");
                parent.setColumnName("provider_path");
                parent.setAlreadyLoaded(this.root.isAlreadyLoaded());
                this.root.add(parent);
            }
            Concept child = pd.getConcept();
            child.setAlreadyLoaded(child.isAlreadyLoaded());
            parent.add(child);
        }
    }

    @Override
    public Concept[] getRoots() {
        if (this.root != null) {
            return new Concept[]{this.root};
        }
        return EMPTY_CONCEPT_ARRAY;
    }

    private TreeMap<Character, Concept> createAlphaCategoryConcepts() throws InvalidConceptCodeException {
        String ca = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        TreeMap<Character, Concept> alpha = new TreeMap<Character, Concept>();
        for (char c : ca.toCharArray()) {
            Concept ontologyNode = this.metadata.getOrCreateHardCodedFolder("Provider", String.valueOf(c));
            ontologyNode.setFactTableColumn("provider_id");
            ontologyNode.setTableName("provider_dimension");
            ontologyNode.setColumnName("provider_path");
            ontologyNode.setAlreadyLoaded(this.root.isAlreadyLoaded());
            alpha.put(Character.valueOf(c), ontologyNode);
            this.root.add(ontologyNode);
        }
        return alpha;
    }
}

