/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.sql.ConnectionSpec;
import org.arp.javautil.sql.SQLExecutor;
import org.protempa.DataSourceReadException;
import org.protempa.backend.dsb.relationaldb.SQLExecutor;
import org.protempa.backend.dsb.relationaldb.SQLGenResultProcessor;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;

public class NonRetryingSQLExecutor
extends SQLExecutor {
    private Connection connection;
    private boolean autoCommit;

    NonRetryingSQLExecutor(ConnectionSpec connectionSpec, String backendNameForMessages, Integer timeout) throws SQLException {
        super(connectionSpec, backendNameForMessages, timeout);
        this.connection = connectionSpec.getOrCreate();
        this.autoCommit = this.connection.getAutoCommit();
    }

    NonRetryingSQLExecutor(Connection connection, String backendNameForMessages, Integer timeout) {
        super(null, backendNameForMessages, timeout);
        this.connection = connection;
    }

    @Override
    void executeSelect(String entitySpecName, String query, SQLGenResultProcessor resultProcessor) throws DataSourceReadException {
        Logger logger = SQLGenUtil.logger();
        if (Boolean.getBoolean("protempa.dsb.relationaldatabase.skipexecution")) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Data source backend {0} is skipping query for {1}", new Object[]{this.getBackendNameForMessages(), entitySpecName});
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Data source backend {0} is executing query for {1}", new Object[]{this.getBackendNameForMessages(), entitySpecName});
            }
            try {
                org.arp.javautil.sql.SQLExecutor.executeSQL((Connection)this.connection, (String)query, (SQLExecutor.ResultProcessor)resultProcessor);
            }
            catch (SQLException ex) {
                throw new DataSourceReadException("Error retrieving " + entitySpecName + " from data source backend " + this.getBackendNameForMessages(), (Throwable)ex);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Query for {0} in data source backend {1} is complete", new Object[]{entitySpecName, this.getBackendNameForMessages()});
            }
        }
    }

    void close() throws SQLException {
        boolean closedSuccessfully = false;
        try {
            if (!this.autoCommit) {
                this.connection.commit();
            }
            this.connection.close();
            closedSuccessfully = true;
        }
        finally {
            if (!closedSuccessfully) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

