/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.value.AbsoluteTimeGranularity;
import org.protempa.proposition.value.DateValueBuilder;
import org.protempa.proposition.value.OrderedValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueList;
import org.protempa.proposition.value.ValueType;
import org.protempa.proposition.value.ValueVisitor;

public class DateValue
implements OrderedValue,
Comparable<DateValue>,
Serializable {
    private static final AbsoluteTimeGranularity gran = AbsoluteTimeGranularity.DAY;
    private static final Map<Date, DateValue> cache = new ReferenceMap();
    private static final long serialVersionUID = 7939358587048726659L;
    private Date date;

    public static DateValue parse(String str) {
        return (DateValue)ValueType.DATEVALUE.parse(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateValue getInstance(Date date) {
        DateValue result;
        if (date != null) {
            Map<Date, DateValue> map = cache;
            synchronized (map) {
                result = cache.get(date);
                if (result == null) {
                    result = new DateValue(date);
                    cache.put(date, result);
                }
            }
        } else {
            result = DateValue.getInstance(new Date());
        }
        return result;
    }

    public static DateValue getInstance() {
        return DateValue.getInstance(null);
    }

    public DateValue() {
        this.init(null);
    }

    public DateValue(Date date) {
        this.init(date);
    }

    private void init(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public String getFormatted() {
        return gran.getShortFormat().format(this.date);
    }

    @Override
    public ValueType getType() {
        return ValueType.DATEVALUE;
    }

    @Override
    public ValueComparator compare(Value o) {
        if (o == null) {
            return ValueComparator.NOT_EQUAL_TO;
        }
        switch (o.getType()) {
            case DATEVALUE: {
                DateValue other = (DateValue)o;
                int comp = this.compareTo(other);
                return comp > 0 ? ValueComparator.GREATER_THAN : (comp < 0 ? ValueComparator.LESS_THAN : ValueComparator.EQUAL_TO);
            }
            case VALUELIST: {
                ValueList vl = (ValueList)o;
                return vl.contains(this) ? ValueComparator.IN : ValueComparator.NOT_IN;
            }
        }
        return ValueComparator.NOT_EQUAL_TO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value replace() {
        DateValue result;
        Map<Date, DateValue> map = cache;
        synchronized (map) {
            result = cache.get(this.date);
        }
        if (result != null) {
            return result;
        }
        return this;
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        if (valueVisitor == null) {
            throw new IllegalArgumentException("valueVisitor cannot be null");
        }
        valueVisitor.visit(this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public int compareTo(DateValue other) {
        return this.date.compareTo(other.date);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.date);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Date tmpDate = (Date)s.readObject();
        this.init(tmpDate);
        if (!cache.containsKey(tmpDate)) {
            cache.put(tmpDate, this);
        }
    }

    public int hashCode() {
        return this.date == null ? 0 : this.date.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateValue other = (DateValue)obj;
        return !(this.date == null ? other.date != null : !this.date.equals(other.date));
    }

    @Override
    public DateValueBuilder asBuilder() {
        return new DateValueBuilder(this);
    }
}

