/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.jdbc.AbstractParameterResultSetHandler;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockNClob;
import com.mockrunner.mock.jdbc.MockParameterMap;
import com.mockrunner.mock.jdbc.MockParameterMetaData;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockResultSetMetaData;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.mock.jdbc.MockUnmodifiableParameterMap;
import com.mockrunner.mock.jdbc.ParameterIndex;
import com.mockrunner.mock.jdbc.ParameterReference;
import com.mockrunner.util.common.StreamUtil;
import com.mockrunner.util.common.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockPreparedStatement
extends MockStatement
implements PreparedStatement {
    private AbstractParameterResultSetHandler resultSetHandler;
    protected final MockParameterMap paramObjects = new MockParameterMap();
    private final List<MockParameterMap> batchParameters = new ArrayList<MockParameterMap>();
    private String sql;
    private MockParameterMetaData parameterMetaData;
    private boolean returnGeneratedKeys = false;

    public MockPreparedStatement(Connection connection, String sql) {
        this(connection, sql, false);
    }

    public MockPreparedStatement(Connection connection, String sql, boolean returnGeneratedKeys) {
        super(connection);
        this.sql = sql;
        this.returnGeneratedKeys = returnGeneratedKeys;
        this.prepareParameterMetaData();
    }

    public MockPreparedStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency) {
        super(connection, resultSetType, resultSetConcurrency);
        this.sql = sql;
        this.prepareParameterMetaData();
    }

    public MockPreparedStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.sql = sql;
        this.prepareParameterMetaData();
    }

    public void setPreparedStatementResultSetHandler(AbstractParameterResultSetHandler resultSetHandler) {
        super.setResultSetHandler(resultSetHandler);
        this.resultSetHandler = resultSetHandler;
    }

    private void prepareParameterMetaData() {
        int number = StringUtil.countMatches((String)this.sql, (String)"?");
        this.parameterMetaData = new MockParameterMetaData();
        this.parameterMetaData.setParameterCount(number);
    }

    public String getSQL() {
        return this.sql;
    }

    public MockParameterMap getIndexedParameterMap() {
        MockParameterMap indexedParameters = new MockParameterMap();
        for (ParameterReference parameterReference : this.paramObjects.keySet()) {
            if (!(parameterReference instanceof ParameterIndex)) continue;
            indexedParameters.put(parameterReference, this.paramObjects.get(parameterReference));
        }
        return new MockUnmodifiableParameterMap(indexedParameters);
    }

    public MockParameterMap getParameterMap() {
        return this.getIndexedParameterMap();
    }

    public Object getParameter(int index) {
        return this.paramObjects.get(index);
    }

    @Override
    public void setObject(int index, Object object) throws SQLException {
        this.paramObjects.put(index, object);
    }

    @Override
    public void setObject(int parameterIndex, Object object, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, object);
    }

    @Override
    public void setObject(int parameterIndex, Object object, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, object);
    }

    @Override
    public void addBatch() throws SQLException {
        this.batchParameters.add(new MockParameterMap(this.paramObjects));
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.batchParameters.clear();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.paramObjects.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        boolean callExecuteQuery = this.isQuery(this.getSQL());
        if (callExecuteQuery) {
            this.executeQuery();
        } else {
            this.executeUpdate();
        }
        return callExecuteQuery;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.paramObjects);
    }

    protected ResultSet executeQuery(MockParameterMap params) throws SQLException {
        SQLException exception = this.resultSetHandler.getSQLException(this.sql, params);
        if (null != exception) {
            throw exception;
        }
        exception = this.resultSetHandler.getSQLException(this.sql);
        if (null != exception) {
            throw exception;
        }
        this.resultSetHandler.addParameterMapForExecutedStatement(this.getSQL(), this.getParameterMapCopy(params));
        MockResultSet[] results = this.resultSetHandler.getResultSets(this.getSQL(), params);
        if (results != null && results.length != 0) {
            this.resultSetHandler.addExecutedStatement(this.getSQL());
            if (results.length > 1) {
                return this.cloneAndSetMultipleResultSets(results, params);
            }
            return this.cloneAndSetSingleResultSet(results[0], params);
        }
        ResultSet superResultSet = super.executeQuery(this.getSQL());
        this.setGeneratedKeysResultSet(this.sql, params);
        return superResultSet;
    }

    private MockResultSet cloneAndSetSingleResultSet(MockResultSet result, MockParameterMap params) {
        if (null != (result = this.cloneResultSet(result))) {
            this.resultSetHandler.addReturnedResultSet(result);
        }
        this.setResultSets(new MockResultSet[]{result});
        this.setGeneratedKeysResultSet(this.sql, params);
        return result;
    }

    private MockResultSet cloneAndSetMultipleResultSets(MockResultSet[] results, MockParameterMap params) {
        if (null != (results = this.cloneResultSets(results))) {
            this.resultSetHandler.addReturnedResultSets(results);
        }
        this.setResultSets(results);
        this.setGeneratedKeysResultSet(this.sql, params);
        if (null != results && results.length > 0) {
            return results[0];
        }
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.paramObjects);
    }

    protected int executeUpdate(MockParameterMap params) throws SQLException {
        SQLException exception = this.resultSetHandler.getSQLException(this.sql, params);
        if (null != exception) {
            throw exception;
        }
        exception = this.resultSetHandler.getSQLException(this.sql);
        if (null != exception) {
            throw exception;
        }
        this.resultSetHandler.addParameterMapForExecutedStatement(this.getSQL(), this.getParameterMapCopy(params));
        Integer[] updateCounts = this.resultSetHandler.getUpdateCounts(this.getSQL(), params);
        if (updateCounts != null && updateCounts.length != 0) {
            this.resultSetHandler.addExecutedStatement(this.getSQL());
            if (updateCounts.length > 1) {
                return this.setMultipleUpdateCounts((Integer[])updateCounts.clone(), params);
            }
            return this.setSingleUpdateCount(updateCounts[0], params);
        }
        int superUpdateCount = super.executeUpdate(this.getSQL());
        this.setGeneratedKeysResultSet(this.sql, params);
        return superUpdateCount;
    }

    private int setSingleUpdateCount(int updateCount, MockParameterMap params) {
        this.setUpdateCounts(new Integer[]{updateCount});
        this.setGeneratedKeysResultSet(this.sql, params);
        return updateCount;
    }

    private int setMultipleUpdateCounts(Integer[] updateCounts, MockParameterMap params) {
        this.setUpdateCounts(updateCounts);
        this.setGeneratedKeysResultSet(this.sql, params);
        if (null != updateCounts && updateCounts.length > 0) {
            return updateCounts[0];
        }
        return 0;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.executeBatch(this.batchParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] executeBatch(List<MockParameterMap> batchParams) throws SQLException {
        try {
            int[] results = new int[batchParams.size()];
            Throwable exception = null;
            for (int ii = 0; ii < results.length; ++ii) {
                if (this.isQuery(this.getSQL())) {
                    exception = this.prepareFailedResult(results, ii, "SQL " + this.getSQL() + " in the list of batches returned a ResultSet.", null);
                } else {
                    try {
                        MockParameterMap currentParameters = batchParams.get(ii);
                        results[ii] = this.executeUpdate(currentParameters);
                    }
                    catch (SQLException exc) {
                        exception = this.prepareFailedResult(results, ii, null, exc);
                    }
                }
                if (null == exception || this.resultSetHandler.getContinueProcessingOnBatchFailure()) continue;
                throw exception;
            }
            if (null != exception) {
                throw new BatchUpdateException(exception.getMessage(), ((SQLException)exception).getSQLState(), ((SQLException)exception).getErrorCode(), results);
            }
            int[] nArray = results;
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    private void setGeneratedKeysResultSet(String sql, MockParameterMap params) {
        MockResultSet generatedKeys = this.resultSetHandler.getGeneratedKeys(sql, params);
        if (this.returnGeneratedKeys) {
            if (null != generatedKeys) {
                this.setLastGeneratedKeysResultSet(generatedKeys);
            } else {
                this.setLastGeneratedKeysResultSet(this.determineGeneratedKeysResultSet(sql));
            }
        } else {
            this.setLastGeneratedKeysResultSet(null);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new MockResultSetMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetaData;
    }

    @Override
    public void setArray(int parameterIndex, Array array) throws SQLException {
        this.setObject(parameterIndex, array);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream) throws SQLException {
        this.setBinaryStream(parameterIndex, stream);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, stream, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, stream, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream);
        this.setObject(parameterIndex, new ByteArrayInputStream(data));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream, (int)length);
        this.setObject(parameterIndex, new ByteArrayInputStream(data));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, stream, (int)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setObject(parameterIndex, new StringReader(data));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)length);
        this.setObject(parameterIndex, new StringReader(data));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal bigDecimal) throws SQLException {
        this.setObject(parameterIndex, bigDecimal);
    }

    @Override
    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        this.setObject(parameterIndex, blob);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)inputStream);
        this.setBlob(parameterIndex, new MockBlob(data));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)inputStream, (int)((int)length));
        this.setBlob(parameterIndex, new MockBlob(data));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean bool) throws SQLException {
        this.setObject(parameterIndex, bool);
    }

    @Override
    public void setByte(int parameterIndex, byte byteValue) throws SQLException {
        this.setObject(parameterIndex, byteValue);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] byteArray) throws SQLException {
        this.setObject(parameterIndex, byteArray);
    }

    @Override
    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        this.setObject(parameterIndex, clob);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setClob(parameterIndex, new MockClob(data));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.setClob(parameterIndex, new MockClob(data));
    }

    @Override
    public void setNClob(int parameterIndex, NClob nClob) throws SQLException {
        this.setObject(parameterIndex, nClob);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setNClob(parameterIndex, new MockNClob(data));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.setNClob(parameterIndex, new MockNClob(data));
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setObject(parameterIndex, xmlObject);
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar calendar) throws SQLException {
        this.setObject(parameterIndex, date);
    }

    @Override
    public void setDate(int parameterIndex, Date date) throws SQLException {
        this.setObject(parameterIndex, date);
    }

    @Override
    public void setDouble(int parameterIndex, double doubleValue) throws SQLException {
        this.setObject(parameterIndex, doubleValue);
    }

    @Override
    public void setFloat(int parameterIndex, float floatValue) throws SQLException {
        this.setObject(parameterIndex, Float.valueOf(floatValue));
    }

    @Override
    public void setInt(int parameterIndex, int intValue) throws SQLException {
        this.setObject(parameterIndex, intValue);
    }

    @Override
    public void setLong(int parameterIndex, long longValue) throws SQLException {
        this.setObject(parameterIndex, longValue);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setRef(int parameterIndex, Ref ref) throws SQLException {
        this.setObject(parameterIndex, ref);
    }

    @Override
    public void setRowId(int parameterIndex, RowId rowId) throws SQLException {
        this.setObject(parameterIndex, rowId);
    }

    @Override
    public void setShort(int parameterIndex, short shortValue) throws SQLException {
        this.setObject(parameterIndex, shortValue);
    }

    @Override
    public void setString(int parameterIndex, String string) throws SQLException {
        this.setObject(parameterIndex, string);
    }

    @Override
    public void setNString(int parameterIndex, String string) throws SQLException {
        this.setObject(parameterIndex, string);
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar calendar) throws SQLException {
        this.setObject(parameterIndex, time);
    }

    @Override
    public void setTime(int parameterIndex, Time time) throws SQLException {
        this.setObject(parameterIndex, time);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timeStamp, Calendar cal) throws SQLException {
        this.setObject(parameterIndex, timeStamp);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timeStamp) throws SQLException {
        this.setObject(parameterIndex, timeStamp);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        this.setObject(parameterIndex, stream);
    }

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        this.setObject(parameterIndex, url);
    }

    private MockParameterMap getParameterMapCopy(MockParameterMap actualParameters) {
        MockParameterMap copyParameters = new MockParameterMap();
        for (ParameterReference key : actualParameters.keySet()) {
            Object actualParameter = actualParameters.get(key);
            Object copyParameter = ParameterUtil.copyParameter(actualParameter);
            copyParameters.put(key, copyParameter);
        }
        return copyParameters;
    }
}

