/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.Arrays;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueType;

public class AlgorithmParameter
implements Serializable {
    private static final long serialVersionUID = 8764701614842981050L;
    private static final ValueComparator[] NULL_VALUE_COMPARATOR_ARRAY = new ValueComparator[0];
    private final String name;
    private final ValueComparator[] comparators;
    private final ValueType valueType;

    public AlgorithmParameter(String name, ValueComparator[] comparators, ValueType valueType) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        this.comparators = comparators == null ? NULL_VALUE_COMPARATOR_ARRAY : comparators;
        this.valueType = valueType;
    }

    public ValueComparator[] getComparators() {
        return this.comparators;
    }

    public String getName() {
        return this.name;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean hasComparator(ValueComparator valueComparator) {
        return org.arp.javautil.arrays.Arrays.contains((Object[])this.comparators, (Object)((Object)valueComparator));
    }

    public String toString() {
        return this.getClass().getName() + " -- name: " + this.name + "; comparators: " + Arrays.asList(this.comparators) + "; valueType: " + (Object)((Object)this.valueType);
    }
}

