/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.LocalUniqueId;
import org.protempa.proposition.LocalUniqueIdValuesProvider;

public final class ProviderBasedLocalUniqueId
implements LocalUniqueId {
    private static final long serialVersionUID = -7548400029812453768L;
    private String id;
    private int numericalId;
    private volatile transient int hashCode;

    public ProviderBasedLocalUniqueId(LocalUniqueIdValuesProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        provider.incr();
        this.id = provider.getId();
        this.numericalId = provider.getNumericalId();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getNumericalId() {
        return this.numericalId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProviderBasedLocalUniqueId other = (ProviderBasedLocalUniqueId)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        return this.numericalId == other.numericalId;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 3;
            hash = 53 * hash + this.id.hashCode();
            this.hashCode = hash = 53 * hash + this.numericalId;
        }
        return this.hashCode;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public LocalUniqueId clone() {
        try {
            ProviderBasedLocalUniqueId clone = (ProviderBasedLocalUniqueId)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError((Object)cnse);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.id);
        s.writeInt(this.numericalId);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.id = (String)s.readObject();
        if (this.id == null) {
            throw new InvalidObjectException("Can't restore. Null id");
        }
        this.numericalId = s.readInt();
    }
}

